//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/agrifood/armagrifood"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// FarmBeatsModelsServer is a fake server for instances of the armagrifood.FarmBeatsModelsClient type.
type FarmBeatsModelsServer struct {
	// CreateOrUpdate is the fake for method FarmBeatsModelsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, farmBeatsResourceName string, body armagrifood.FarmBeats, options *armagrifood.FarmBeatsModelsClientCreateOrUpdateOptions) (resp azfake.Responder[armagrifood.FarmBeatsModelsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method FarmBeatsModelsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, farmBeatsResourceName string, options *armagrifood.FarmBeatsModelsClientDeleteOptions) (resp azfake.Responder[armagrifood.FarmBeatsModelsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method FarmBeatsModelsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, farmBeatsResourceName string, options *armagrifood.FarmBeatsModelsClientGetOptions) (resp azfake.Responder[armagrifood.FarmBeatsModelsClientGetResponse], errResp azfake.ErrorResponder)

	// GetOperationResult is the fake for method FarmBeatsModelsClient.GetOperationResult
	// HTTP status codes to indicate success: http.StatusOK
	GetOperationResult func(ctx context.Context, resourceGroupName string, farmBeatsResourceName string, operationResultsID string, options *armagrifood.FarmBeatsModelsClientGetOperationResultOptions) (resp azfake.Responder[armagrifood.FarmBeatsModelsClientGetOperationResultResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method FarmBeatsModelsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armagrifood.FarmBeatsModelsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armagrifood.FarmBeatsModelsClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method FarmBeatsModelsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armagrifood.FarmBeatsModelsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armagrifood.FarmBeatsModelsClientListBySubscriptionResponse])

	// BeginUpdate is the fake for method FarmBeatsModelsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, farmBeatsResourceName string, body armagrifood.FarmBeatsUpdateRequestModel, options *armagrifood.FarmBeatsModelsClientBeginUpdateOptions) (resp azfake.PollerResponder[armagrifood.FarmBeatsModelsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewFarmBeatsModelsServerTransport creates a new instance of FarmBeatsModelsServerTransport with the provided implementation.
// The returned FarmBeatsModelsServerTransport instance is connected to an instance of armagrifood.FarmBeatsModelsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewFarmBeatsModelsServerTransport(srv *FarmBeatsModelsServer) *FarmBeatsModelsServerTransport {
	return &FarmBeatsModelsServerTransport{
		srv:                         srv,
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armagrifood.FarmBeatsModelsClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armagrifood.FarmBeatsModelsClientListBySubscriptionResponse]](),
		beginUpdate:                 newTracker[azfake.PollerResponder[armagrifood.FarmBeatsModelsClientUpdateResponse]](),
	}
}

// FarmBeatsModelsServerTransport connects instances of armagrifood.FarmBeatsModelsClient to instances of FarmBeatsModelsServer.
// Don't use this type directly, use NewFarmBeatsModelsServerTransport instead.
type FarmBeatsModelsServerTransport struct {
	srv                         *FarmBeatsModelsServer
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armagrifood.FarmBeatsModelsClientListByResourceGroupResponse]]
	newListBySubscriptionPager  *tracker[azfake.PagerResponder[armagrifood.FarmBeatsModelsClientListBySubscriptionResponse]]
	beginUpdate                 *tracker[azfake.PollerResponder[armagrifood.FarmBeatsModelsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for FarmBeatsModelsServerTransport.
func (f *FarmBeatsModelsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "FarmBeatsModelsClient.CreateOrUpdate":
		resp, err = f.dispatchCreateOrUpdate(req)
	case "FarmBeatsModelsClient.Delete":
		resp, err = f.dispatchDelete(req)
	case "FarmBeatsModelsClient.Get":
		resp, err = f.dispatchGet(req)
	case "FarmBeatsModelsClient.GetOperationResult":
		resp, err = f.dispatchGetOperationResult(req)
	case "FarmBeatsModelsClient.NewListByResourceGroupPager":
		resp, err = f.dispatchNewListByResourceGroupPager(req)
	case "FarmBeatsModelsClient.NewListBySubscriptionPager":
		resp, err = f.dispatchNewListBySubscriptionPager(req)
	case "FarmBeatsModelsClient.BeginUpdate":
		resp, err = f.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (f *FarmBeatsModelsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if f.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AgFoodPlatform/farmBeats/(?P<farmBeatsResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armagrifood.FarmBeats](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	farmBeatsResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("farmBeatsResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, farmBeatsResourceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FarmBeats, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FarmBeatsModelsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if f.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AgFoodPlatform/farmBeats/(?P<farmBeatsResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	farmBeatsResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("farmBeatsResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Delete(req.Context(), resourceGroupNameParam, farmBeatsResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FarmBeatsModelsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if f.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AgFoodPlatform/farmBeats/(?P<farmBeatsResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	farmBeatsResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("farmBeatsResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Get(req.Context(), resourceGroupNameParam, farmBeatsResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FarmBeats, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FarmBeatsModelsServerTransport) dispatchGetOperationResult(req *http.Request) (*http.Response, error) {
	if f.srv.GetOperationResult == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetOperationResult not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AgFoodPlatform/farmBeats/(?P<farmBeatsResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operationResults/(?P<operationResultsId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	farmBeatsResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("farmBeatsResourceName")])
	if err != nil {
		return nil, err
	}
	operationResultsIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationResultsId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.GetOperationResult(req.Context(), resourceGroupNameParam, farmBeatsResourceNameParam, operationResultsIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ArmAsyncOperation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FarmBeatsModelsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := f.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AgFoodPlatform/farmBeats`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		maxPageSizeUnescaped, err := url.QueryUnescape(qp.Get("$maxPageSize"))
		if err != nil {
			return nil, err
		}
		maxPageSizeParam, err := parseOptional(maxPageSizeUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		var options *armagrifood.FarmBeatsModelsClientListByResourceGroupOptions
		if maxPageSizeParam != nil || skipTokenParam != nil {
			options = &armagrifood.FarmBeatsModelsClientListByResourceGroupOptions{
				MaxPageSize: maxPageSizeParam,
				SkipToken:   skipTokenParam,
			}
		}
		resp := f.srv.NewListByResourceGroupPager(resourceGroupNameParam, options)
		newListByResourceGroupPager = &resp
		f.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armagrifood.FarmBeatsModelsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		f.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (f *FarmBeatsModelsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := f.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AgFoodPlatform/farmBeats`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		maxPageSizeUnescaped, err := url.QueryUnescape(qp.Get("$maxPageSize"))
		if err != nil {
			return nil, err
		}
		maxPageSizeParam, err := parseOptional(maxPageSizeUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armagrifood.FarmBeatsModelsClientListBySubscriptionOptions
		if maxPageSizeParam != nil || skipTokenParam != nil {
			options = &armagrifood.FarmBeatsModelsClientListBySubscriptionOptions{
				MaxPageSize: maxPageSizeParam,
				SkipToken:   skipTokenParam,
			}
		}
		resp := f.srv.NewListBySubscriptionPager(options)
		newListBySubscriptionPager = &resp
		f.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armagrifood.FarmBeatsModelsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		f.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (f *FarmBeatsModelsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if f.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := f.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AgFoodPlatform/farmBeats/(?P<farmBeatsResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armagrifood.FarmBeatsUpdateRequestModel](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		farmBeatsResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("farmBeatsResourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := f.srv.BeginUpdate(req.Context(), resourceGroupNameParam, farmBeatsResourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		f.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		f.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		f.beginUpdate.remove(req)
	}

	return resp, nil
}
