package main

import (
	"html/template"
	"path"
	"reflect"
	"strings"
)

// funcs returns functions for use in templates.
func (s *Site) funcs() map[string]interface{} {
	return map[string]interface{}{
		"dir":          s.dir,
		"exec":         executeString,
		"page":         s.page,
		"path":         func() _path { return _path{} },
		"partial":      s.templates.ExecutePartial,
		"reverse":      reverse,
		"safeCSS":      func(s string) template.CSS { return template.CSS(s) },
		"safeHTML":     func(s string) template.HTML { return template.HTML(s) },
		"safeHTMLAttr": func(s string) template.HTMLAttr { return template.HTMLAttr(s) },
		"safeJS":       func(s string) template.JS { return template.JS(s) },
		"safeURL":      func(s string) template.URL { return template.URL(s) },
		"site":         func() *Site { return s },
		"strings":      func() _strings { return _strings{} },
	}
}

type _path struct{}

func (_path) Base(s string) string            { return path.Base(s) }
func (_path) Clean(s string) string           { return path.Clean(s) }
func (_path) Dir(s string) string             { return path.Dir(s) }
func (_path) Ext(s string) string             { return path.Ext(s) }
func (_path) Join(elem ...string) string      { return path.Join(elem...) }
func (_path) Split(s string) (string, string) { return path.Split(s) }

type _strings struct{}

func (_strings) Count(a, b string) int                { return strings.Count(a, b) }
func (_strings) HasPrefix(a, b string) bool           { return strings.HasPrefix(a, b) }
func (_strings) HasSuffix(a, b string) bool           { return strings.HasSuffix(a, b) }
func (_strings) Join(elems []string, s string) string { return strings.Join(elems, s) }
func (_strings) Repeat(s string, i int) string        { return strings.Repeat(s, i) }
func (_strings) Replace(a, b, c string, n int) string { return strings.Replace(a, b, c, n) }
func (_strings) ReplaceAll(a, b, c string) string     { return strings.ReplaceAll(a, b, c) }
func (_strings) Split(a, b string) []string           { return strings.Split(a, b) }
func (_strings) Title(s string) string                { return strings.Title(s) }
func (_strings) ToLower(s string) string              { return strings.ToLower(s) }
func (_strings) ToUpper(s string) string              { return strings.ToUpper(s) }
func (_strings) Trim(a, b string) string              { return strings.Trim(a, b) }
func (_strings) TrimLeft(a, b string) string          { return strings.TrimLeft(a, b) }
func (_strings) TrimPrefix(a, b string) string        { return strings.TrimPrefix(a, b) }
func (_strings) TrimRight(a, b string) string         { return strings.TrimRight(a, b) }
func (_strings) TrimSpace(s string) string            { return strings.TrimSpace(s) }
func (_strings) TrimSuffix(a, b string) string        { return strings.TrimSuffix(a, b) }

func executeString(command, input string) string {
	var b strings.Builder
	execute(command, strings.NewReader(input), &b)
	return b.String()
}

func reverse(s interface{}) interface{} {
	v := reflect.ValueOf(s)
	n := v.Len()
	r := reflect.MakeSlice(v.Type(), n, n)
	reflect.Copy(r, v)
	swap := reflect.Swapper(r.Interface())
	for i, j := 0, n-1; i < j; i, j = i+1, j-1 {
		swap(i, j)
	}
	return r.Interface()
}
