/*
 * GMTK_PermutationSegmentSchedule.h
 * 
 * Written by Richard Rogers <rprogers@ee.washington.edu>
 *
 * Copyright (C) 2015 Jeff Bilmes
 * Licensed under the Open Software License version 3.0
 * See COPYING or http://opensource.org/licenses/OSL-3.0
 *
 */

#ifndef GMTK_PERMUTATIONSEGMENTSCHEDULE_H
#define GMTK_PERMUTATIONSEGMENTSCHEDULE_H

#include "GMTK_BaseSegmentSchedule.h"

// The batch order is determined by a randomly chosen permutation
// generated by a cubic residue process. This can only generate
// O(n^2) of the possible n! permutations, but it only requires O(1)
// space vs. the O(n) space required by the Knuth shuffle.

class PermutationSegmentSchedule : public BaseSegmentSchedule {
 private:
  Range batch_numbers;   // sequential batch #'s [0, n)
  Range::permuter sigma; // permutation of batch_numbers

 public:

  PermutationSegmentSchedule(FileSource *obs_source, char const *trrng_str, unsigned batch_size) 
    : BaseSegmentSchedule(obs_source, trrng_str, batch_size), batch_numbers(NULL)
  {
    batch_numbers.SetLimits(0, num_training_units);
    sigma = batch_numbers.permute();
  }

  // Returns a vector containing the segment numbers for the next batch
  void getBatch(vector<unsigned> &batch) {
    unsigned first_segment = batch_size * 
      ( (0 == num_batches_dispensed) ? sigma.reset() : sigma.next_el());
    generateBatch(first_segment, batch);
  }

};

#endif // GMTK_PERMUTATIONSEGMENTSCHEDULE
