/*
**
** PHiPAC Matrix-Matrix Code for the operation:
**    C = alpha*A*transpose(B) + C
**
** Automatically Generated by mm_lgen ($Revision: 1.5 $) using the command:
**    ./mm_lgen -prec double -opA N -opB T -alpha c -sp 1 -l0 1 17 9 -l1 47 3 6 -gen_rout mm_double_NT_c_general -gen_nf_rout mm_double_NT_c_nofringe -file ./src/mm_double_NT_c_l1.c -routine_name mm_double_NT_c_l1 
**
** Run './mm_lgen -help' for help.
**
** Generated on: Wednesday July 10 2013, 08:33:28 PDT
** Created by: Jeff Bilmes <bilmes@cs.berkeley.edu>
**             http://www.icsi.berkeley.edu/~bilmes/phipac
**
**
** Routine Usage: 
**    mm_double_NT_c_l1(const int M, const int K, const int N, const double *const A, const double *const B, double *const C, const int Astride, const int Bstride, const int Cstride, const double alpha)
** where
**  A is an MxK matrix
**  transpose(B) is an KxN matrix
**  C is an MxN matrix
**  Astride is the number of entries between the start of each row of A
**  Bstride is the number of entries between the start of each row of B
**  Cstride is the number of entries between the start of each row of C
**
**
** "Copyright (c) 1995 The Regents of the University of California.  All
** rights reserved."  Permission to use, copy, modify, and distribute
** this software and its documentation for any purpose, without fee, and
** without written agreement is hereby granted, provided that the above
** copyright notice and the following two paragraphs appear in all copies
** of this software.
**
** IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
** DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
** OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
** CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
** THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
** INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
** AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
** ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
** PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
**
*/

extern mm_double_NT_c_general(const int M, const int K, const int N, const double *const A, const double *const B, double *const C, const int Astride, const int Bstride, const int Cstride, const double alpha);
extern mm_double_NT_c_nofringe(const int M, const int K, const int N, const double *const A, const double *const B, double *const C, const int Astride, const int Bstride, const int Cstride, const double alpha);


void
mm_double_NT_c_l1(const int M, const int K, const int N, const double *const A, const double *const B, double *const C, const int Astride, const int Bstride, const int Cstride, const double alpha)
{
   int m,k,n;
   const double *a,*b;
   double *c;
   const double *ap,*bp;
   double *cp;
   const int m_marg = (M % 47) - (M % 1);
   const int k_marg = (K % 51) - ((K%51)-0)%17;
   const int n_marg = (N % 54) - (N % 9);
   for (m=0; (m+47)<=M; m+=47) {
      c = C + m*Cstride;
      a = A + m*Astride;
      for (n=0,b=B,cp=c; (n+54)<=N; n+=54,b+=54*Bstride,cp+=54) {
         for (k=0,bp=b,ap=a; (k+51)<=K; k+=51,bp+=51,ap+=51) {
            mm_double_NT_c_nofringe(47,51,54,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
         if (k + 17 <= K) {
            mm_double_NT_c_nofringe(47,k_marg,54,ap,bp,cp,Astride,Bstride,Cstride,alpha);
            k+=k_marg;bp+=k_marg;ap+=k_marg;
         }
         if (k < K) {
            mm_double_NT_c_general(47,K-k,54,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
      }
      if (n + 9 <= N) {
         for (k=0,bp=b,ap=a; (k+51)<=K; k+=51,bp+=51,ap+=51) {
            mm_double_NT_c_nofringe(47,51,n_marg,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
         if (k + 17 <= K) {
            mm_double_NT_c_nofringe(47,k_marg,n_marg,ap,bp,cp,Astride,Bstride,Cstride,alpha);
            k+=k_marg;bp+=k_marg;ap+=k_marg;
         }
         if (k < K) {
            mm_double_NT_c_general(47,K-k,n_marg,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
         n+=n_marg;b+=n_marg*Bstride;cp+=n_marg;
      }
      if (n < N) {
         for (k=0,bp=b,ap=a; (k+51)<=K; k+=51,bp+=51,ap+=51) {
            mm_double_NT_c_general(47,51,N-n,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
         if (k + 17 <= K) {
            mm_double_NT_c_general(47,k_marg,N-n,ap,bp,cp,Astride,Bstride,Cstride,alpha);
            k+=k_marg;bp+=k_marg;ap+=k_marg;
         }
         if (k < K) {
            mm_double_NT_c_general(47,K-k,N-n,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
      }
   }
   if (m + 1 <= M) {
      c = C + m*Cstride;
      a = A + m*Astride;
      for (n=0,b=B,cp=c; (n+54)<=N; n+=54,b+=54*Bstride,cp+=54) {
         for (k=0,bp=b,ap=a; (k+51)<=K; k+=51,bp+=51,ap+=51) {
            mm_double_NT_c_nofringe(m_marg,51,54,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
         if (k + 17 <= K) {
            mm_double_NT_c_nofringe(m_marg,k_marg,54,ap,bp,cp,Astride,Bstride,Cstride,alpha);
            k+=k_marg;bp+=k_marg;ap+=k_marg;
         }
         if (k < K) {
            mm_double_NT_c_general(m_marg,K-k,54,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
      }
      if (n + 9 <= N) {
         for (k=0,bp=b,ap=a; (k+51)<=K; k+=51,bp+=51,ap+=51) {
            mm_double_NT_c_nofringe(m_marg,51,n_marg,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
         if (k + 17 <= K) {
            mm_double_NT_c_nofringe(m_marg,k_marg,n_marg,ap,bp,cp,Astride,Bstride,Cstride,alpha);
            k+=k_marg;bp+=k_marg;ap+=k_marg;
         }
         if (k < K) {
            mm_double_NT_c_general(m_marg,K-k,n_marg,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
         n+=n_marg;b+=n_marg*Bstride;cp+=n_marg;
      }
      if (n < N) {
         for (k=0,bp=b,ap=a; (k+51)<=K; k+=51,bp+=51,ap+=51) {
            mm_double_NT_c_general(m_marg,51,N-n,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
         if (k + 17 <= K) {
            mm_double_NT_c_general(m_marg,k_marg,N-n,ap,bp,cp,Astride,Bstride,Cstride,alpha);
            k+=k_marg;bp+=k_marg;ap+=k_marg;
         }
         if (k < K) {
            mm_double_NT_c_general(m_marg,K-k,N-n,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
      }
      m+=m_marg;
   }
   if (m < M) {
      c = C + m*Cstride;
      a = A + m*Astride;
      for (n=0,b=B,cp=c; (n+54)<=N; n+=54,b+=54*Bstride,cp+=54) {
         for (k=0,bp=b,ap=a; (k+51)<=K; k+=51,bp+=51,ap+=51) {
            mm_double_NT_c_general(M-m,51,54,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
         if (k + 17 <= K) {
            mm_double_NT_c_general(M-m,k_marg,54,ap,bp,cp,Astride,Bstride,Cstride,alpha);
            k+=k_marg;bp+=k_marg;ap+=k_marg;
         }
         if (k < K) {
            mm_double_NT_c_general(M-m,K-k,54,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
      }
      if (n + 9 <= N) {
         for (k=0,bp=b,ap=a; (k+51)<=K; k+=51,bp+=51,ap+=51) {
            mm_double_NT_c_general(M-m,51,n_marg,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
         if (k + 17 <= K) {
            mm_double_NT_c_general(M-m,k_marg,n_marg,ap,bp,cp,Astride,Bstride,Cstride,alpha);
            k+=k_marg;bp+=k_marg;ap+=k_marg;
         }
         if (k < K) {
            mm_double_NT_c_general(M-m,K-k,n_marg,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
         n+=n_marg;b+=n_marg*Bstride;cp+=n_marg;
      }
      if (n < N) {
         for (k=0,bp=b,ap=a; (k+51)<=K; k+=51,bp+=51,ap+=51) {
            mm_double_NT_c_general(M-m,51,N-n,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
         if (k + 17 <= K) {
            mm_double_NT_c_general(M-m,k_marg,N-n,ap,bp,cp,Astride,Bstride,Cstride,alpha);
            k+=k_marg;bp+=k_marg;ap+=k_marg;
         }
         if (k < K) {
            mm_double_NT_c_general(M-m,K-k,N-n,ap,bp,cp,Astride,Bstride,Cstride,alpha);
         }
      }
   }
}
