// $Id: spinbutton.cc,v 1.41 2004/05/10 14:08:21 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "entry.hh"

class Gtk_SpinButton : public Gtk_Entry
{	const Widget get_adjustment(const Widget &w) const;
public:
	typedef Gtk_Entry Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_SpinButton();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool CantMemberConstruct(const Widget &) const;
	virtual void CreatePointer(const Widget &, CxxFile &) const;
	virtual void DestroyPointer(const Widget &w,CxxFile &f) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
	virtual void GCInclude(const Widget &w, CxxFile &f) const;
	virtual bool isProxySignal(const Widget &w,std::string &method,bool after) const;
};

static Gtk_SpinButton Gtk_SpinButton;

#define COPY_TAG(name) w2.setProperty((name),w.getProperty(name))
const Widget Gtk_SpinButton::get_adjustment(const Widget &w) const
{  static Tag adjustment("widget");
   std::string name(Configuration.InstanceName(w.Name())+"_adj");
   if (Widget(adjustment).Name()==name)
   {  return Widget(adjustment);
   }
   adjustment=createWidgetTag("GtkAdjustment", name);
   Widget w2(adjustment);
   if (Configuration.glade2) COPY_TAG("adjustment");
   else
   {  COPY_TAG("value");
      COPY_TAG("lower");
      COPY_TAG("upper");
      COPY_TAG("step");
      COPY_TAG("page");
      COPY_TAG("page_size");
   }
   w2.setProperty(CXX_IS_MANAGED);
   return w2;
}

const std::string Gtk_SpinButton::TypeName(const Widget &w) const
{  return GtkPrefix()+"SpinButton";
}

const std::string Gtk_SpinButton::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"spinbutton.h";
}

// we rely on adjustment getting a local variable
void Gtk_SpinButton::GCInclude(const Widget &w, CxxFile &f) const
{  Parent::GCInclude(w,f);
   Widget w2(get_adjustment(w));
   LookupWriter(w2).GCInclude(w2,f);
}

Gtk_SpinButton::Gtk_SpinButton()
{  Writer["GtkSpinButton"]=this;
}

bool Gtk_SpinButton::CantMemberConstruct(const Widget &w) const
{  return true; }

void Gtk_SpinButton::CreatePointer(const Widget &w,CxxFile &f) const
{  Widget w2(get_adjustment(w));
   LookupWriter(w2).CreatePointer(w2,f); 
   Parent::CreatePointer(w,f);
}

void Gtk_SpinButton::DestroyPointer(const Widget &w,CxxFile &f) const
{  Parent::DestroyPointer(w,f);
   Widget w2(get_adjustment(w));
   LookupWriter(w2).DestroyPointer(w2,f); 
}

void Gtk_SpinButton::ConstructionArgs(const Widget &w, CxxFile &f) const
{  Widget w2(get_adjustment(w));
   f.FunctionArg() << Reference(w2);
   f.FunctionArg() << w.getIntProperty("climb_rate",0);
   f.FunctionArg() << w.getIntProperty("digits",0);
}

void Gtk_SpinButton::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteEnumPropertyNS(w,f,instance, "update_policy");
   WriteBoolProperty(w,f,instance, "numeric");
   WriteIntProperty(w,f,instance, "digits");
   WriteBoolProperty(w,f,instance, "wrap");
   WriteBoolProperty(w,f,instance, "snap", false, "snap_to_ticks");
   WriteEnumPropertyNS(w,f,instance, "shadow_type");
}

bool Gtk_SpinButton::isProxySignal(const Widget &w,std::string &method,bool after) const
{  if (method=="activate" && !after)
      std::cerr << "You really should connect with 'after' to " << w.Name() 
      		<< "'s " << method << '\n';
   return Parent::isProxySignal(w,method,after);
}
