// $Id: packer.cc,v 1.13 2002/06/15 13:22:14 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gtk_Packer : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Packer();
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
	virtual void AddChild(const Widget &w,CxxFile &f,const std::string &instance) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
};

static Gtk_Packer Gtk_Packer;

const std::string Gtk_Packer::TypeName(const Widget &w) const
{  return GtkPrefix()+"Packer";
}

const std::string Gtk_Packer::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"packer.h";
}

Gtk_Packer::Gtk_Packer()
{  Writer["GtkPacker"]=this;
}

void Gtk_Packer::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
}

#define PACKER_DEFAULT (~((unsigned int)0))

void Gtk_Packer::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{  const ChildParamList ch=w.get_Child_params();
   unsigned int border_width=ch.getIntProperty("border_width",PACKER_DEFAULT);
   unsigned int pad_x=ch.getIntProperty("xpad",PACKER_DEFAULT);
   unsigned int pad_y=ch.getIntProperty("ypad",PACKER_DEFAULT);
   unsigned int i_pad_x=ch.getIntProperty("xipad",PACKER_DEFAULT);
   unsigned int i_pad_y=ch.getIntProperty("yipad",PACKER_DEFAULT);
   std::string side(ch.getProperty("side","GTK_SIDE_TOP"));
   std::string anchor(ch.getProperty("anchor","GTK_ANCHOR_CENTER"));

   std::string options("0");
   if (ch.getBoolProperty("expand",false)) options+="|GTK_EXPAND";
   if (ch.getBoolProperty("xfill",false)) options+="|GTK_FILL_X";
   if (ch.getBoolProperty("yfill",false)) options+="|GTK_FILL_Y";
   // strip leading '0|'
   if (options.size()>1) options=options.substr(2);
   
   bool use_default(ch.getBoolProperty("use_default",true)); // ???
   if (!use_default)
   {  f.Statement() << instance << "add(" 
        << Reference(w) << ", " << side << ", " << anchor 
        << ", " << Gtkmm2Namespace(options) << ", " << border_width << ", " 
        << pad_x << ", " << pad_y << ", " << i_pad_x << ", " << i_pad_y << ')';
   }
   else // just a guess
   {  f.Statement() << instance << "add(" 
        << Reference(w) << ", " << side << ", " << anchor  
        << ", " << Gtkmm2Namespace(options) << ')';
   }
}

void Gtk_Packer::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

   WriteIntProperty(w,f,instance, "default_border_width");
   WriteIntIntProperty(w,f,instance, "default_pad_x", "default_pad_y", "default_pad");
   WriteIntIntProperty(w,f,instance, "default_ipad_x", "default_ipad_y", "default_ipad");
}

