  !
  !   Id: LissajousSubscansXML.inc, v1.2.3 2014-07-16 Hans Ungerechts
  !
  Call pako_message(seve%t,programName,                                          &
       &      " module Lissajous,"                                               &
       &    //"   -> LissajousSubscansXML.inc, v1.2.3  2014-07-16 ")             ! trace execution
  !
  !D   Write (6,*) "      ---> StartXML/LissajousSubscansXML.f90 "
  !D   Write (6,*) "           number of SS segments:   ", nSegments
  !
  Call pakoXMLwriteStartElement("RESOURCE","subscans",                           &
       &                         comment="generated by paKo",                    &
       &                         space ="before",                                &
       &                         error=errorXML)                                 !
  !
  inOtfSubscan = .False.
  !
  Do ii = 1, nSegments, 1
     !
     !D      Write (6,*) "          ii:            ", ii
     !D      Write (6,*) "          segList(ii):   ", segList(ii)
     !
     If (segList(ii)%ssType.Eq.ss%track) Then
        !
        Include 'inc/startXML/trackXML.inc'
        !
     End If
     !
     ! ***    OTF subscan
     If (segList(ii)%ssType.Eq.ss%otf) Then
        !
        ! ***       start of OTF subscan
        If (segList(ii)%newSubscan) Then
           inOtfSubscan = .True.
           Call pakoXMLwriteStartElement("RESOURCE","subscan",                   &
                &                         comment="OTF",                         &
                &                         error=errorXML)                        !
           valueC = segList(ii)%ssType
           Call pakoXMLcase(valueC,error=errorXML)
           If (valueC.Eq."OTF") valueC="onTheFly"
           Call pakoXMLwriteElement("PARAM","type",valueC,                       &
                &                         dataType="char",                       &
                &                         error=errorXML)                        !
           valueC = segList(ii)%systemName
           Call pakoXMLcase(valueC,error=errorXML)
           If (valueC.Eq."horizontalT") valueC="horizontalTrue"
           Call pakoXMLwriteElement("PARAM","systemOffset",valueC,               &
                &                         dataType="char",                       &
                &                         error=errorXML)                        !
           !
           ! TBD:     Write (valueC,*) segList(ii)%tRecord
           ! TBD:     Call pakoXMLwriteElement("PARAM","tRecord",valueC,  &
           ! TBD:  &                  dataType="char",                    &
           ! TBD:  &                  error=errorXML)                     !
           !
           Include 'inc/startXML/pOffsetDoppler.inc'
           !
           If (  segList(ii)%directionFocus .Ne. GPnone  )  Then
              !
              Call pakoXMLwriteStartElement("RESOURCE","presets",                &
                   !! &                      comment="   ",                      &
                   &                         error=errorXML)                     !  
              !
              Call pakoXMLwriteStartElement("RESOURCE","focusPreset",            &
                   !! &                      comment="   ",                      &
                   &                         error=errorXML)                     !  
              !
              Write (valueC,*)       Real(segList(ii)%focusOffset)
              Write (valueComment,*) Real(segList(ii)%focusOffset), "mm"
              Call pakoXMLwriteElement("PARAM","focusOffset",valueC,             &
                   &                         dataType="float",                   &
                   &                         unit="mm",                          &
                   &                         comment=valueComment,               &
                   &                         error=errorXML)                     !
              !
              valueC  =  segList(ii)%directionFocus
              Call pakoXMLcase(valueC,error=errorXML)
              Call pakoXMLwriteElement("PARAM","focusTranslation",valueC,        &
                   &                         dataType="char",                    &
                   &                         error=errorXML)                     !
              !
              Call pakoXMLwriteEndElement("RESOURCE","focusPreset",              &
                   &                         error=errorXML)                     !
              !
              Call pakoXMLwriteEndElement("RESOURCE","presets",                  &
                   &                         error=errorXML)                     !
              !
           End If
           !
           Call pakoXMLwriteStartElement("RESOURCE","segments",                  &
                &                         error=errorXML)                        !
           !
        End If
        !
        ! ***       OTF segments
        !
!!$        If (segList(ii)%ssType.Eq.ss%otf .And.                                   &
!!$             &       segList(ii)%segType.Eq.seg%track) Then                      !
!!$           Include 'inc/startXML/segTrackXML.inc'
!!$        End If
        !
        If (segList(ii)%ssType.Eq.ss%otf .And.                                   &
             &       segList(ii)%segType.Eq.seg%linear) Then                     !
           Include 'inc/startXML/segLinearXML.inc'
        End If
        !
!!$        If (segList(ii)%ssType.Eq.ss%otf .And.                                   &
!!$             &       segList(ii)%segType.Eq.seg%circle) Then                     !
!!$           Include 'inc/startXML/segCircleXML.inc'
!!$        End If
        !
        If (segList(ii)%ssType.Eq.ss%otf .And.                                   &
             &       segList(ii)%segType.Eq.seg%curve) Then                      !
           Include 'inc/startXML/segCurveXML.inc'
        End If
        !
        If (segList(ii)%ssType.Eq.ss%otf .And.                                   &
             &       segList(ii)%segType.Eq.seg%lissajous) Then                  !
           Include 'inc/startXML/segLissajousXML.inc'
        End If
        !
        ! ***       end of OTF subscan
        If (ii.Eq.nSegments .Or.                                                 &
             &  ii.Lt.nSegments .And. segList(ii+1)%newSubscan) Then             !
           Call pakoXMLwriteEndElement("RESOURCE","segments",                    &
                &                         error=errorXML)                        !
           Call pakoXMLwriteEndElement("RESOURCE","subscan",                     &
                &                         error=errorXML)                        !
           inOtfSubscan = .False.
        End If
        !
     End If
     !
  End Do
  !
  Call pakoXMLwriteEndElement("RESOURCE","subscans",                             &  
       &                         error=errorXML)                                 !
  !





