  !
  ! Id: parametersSetKeywordValue.inc ,v 1.3.0  2017-10-09 Hans Ungerechts
  !                                   ,v 1.2.6  2017-03-21 Hans Ungerechts
  !                                   ,v 1.2.3  2014-10-29 Hans Ungerechts
  !                                   ,v 1.2.3  2014-10-29 Hans Ungerechts
  !                                             2014-03-13 Hans Ungerechts
  !     based on:
  !     parametersSetKeywordValue.inc ,v 1.1.12 2012-03-17 Hans Ungerechts
  !
  Call pako_message(seve%t,programName,                                          &
       &  " modulePakoGlobalVariables ,v 1.3.0  2017-10-09 "                     &
       &  //"  -> parametersSetKeywordValue.inc ")                               ! trace execution
  !
  error  = .False.
  errorL = .False.
  errorR = .False.
  errorC = .False.
  !
  ! *** Keyword
  If (SIC_NARG(0).Ge.1.) Then
     iOption   = 0
     iArgument = 1
     Call SIC_CH(LINE,iOption,iArgument,                                         &
          &        cInputLong,lengthInput,.True.,errorC)
     Call SIC_UPPER(cInputLong)
     keyword =  cInputLong(1:lengthInput)
  Else
     errorL = .True.
     messageText =                                                               &
          &        "no keyword specified"
     Call PakoMessage(priorityE,severityE,command,messageText)
  End If
  !
  error = error .Or. errorC .Or. errorL
  !
  If (.Not. error) Then
     Call pakoUmatchKey (                                                        &
          &              keys=setChoices,                                        &
          &              key=keyword,                                            &
          &              command='SET',                                          &
          &              howto='Start Upper',                                    &
          &              iMatch=iMatch,                                          &
          &              nMatch=nMatch,                                          &
          &              error=errorC,                                           &
          &              errorCode=errorCode                                     &
          &             )
  End If
  !
  error = error .Or. errorC
  !
  ! *** Value
  If (SIC_NARG(0).Ge.2.) Then
     iOption   = 0
     iArgument = 2
     Call SIC_CH(LINE,iOption,iArgument,                                         &
          &        cInput256,lengthInput,.True.,errorC)
     valueC =  cInput256(1:lengthInput)
     Call pakoSpecialChar(cInput256,command=command,hasSpecial=errorC)
     If (errorC) Then
        messageText =                                                            &
             &        cInput256(1:lengthInput)//" invalid"
        Call pakoMessage(priorityE,severityE,command,messageText)
     End If
  Else
     errorL = .True.
     messageText =                                                               &
          &        "no value specified"
     Call PakoMessage(priorityE,severityE,command,messageText)
  End If
  !
  error = error .Or. errorC .Or. errorL
  !
  !D Write (6,*) "      -> parametersSetKeywordValue: ", keyword, valueC
  !
  If (.Not. error) Then
     !
     Select Case (keyword)
        !
     Case("OBSERVER")
        GV%observer = valueC
        !
     Case("OPERATOR")
        GV%oper     = valueC
        !
     Case("PI")
        !
        !D       Write (6,*) "      case PI "
        !D       Write (6,*) "      SIC_NARG(0): ", SIC_NARG(0)
        If ( SIC_NARG(0).Gt.2 ) Then
           Write (messageText,*)                                                 &
                & "Usage: SET PI name "                                          !
           Call PakoMessage(priorityE,severityE,command,messageText)
           Write (messageText,*)                                                 &
                &    " maybe you mean "                                          &
                &  //" SET POINTING azimuthCorrection elevationCorrection "      !
           Call PakoMessage(priorityI,severityI,command,messageText)
        Else
           GV%PI = valueC
        End If
        !
!!$         iArgument = 2
!!$         Call SIC_R4(LINE,iOption,iArgument,rInput,.False.,errorR)
!!$         If (.Not. errorR) Then
!!$            Write (messageText,*)                                             &
!!$                 & "Usage: SET PI name "                                      !
!!$            Call PakoMessage(priorityE,severityE,command,messageText)
!!$            Write (messageText,*)                                             &
!!$                 &    " maybe you mean "                                      &
!!$                 &  //" SET POINTING azimuthCorrection elevationCorrection "  !
!!$            Call PakoMessage(priorityI,severityI,command,messageText)
!!$         Else
!!$            GV%PI = valueC
!!$         End If
!!$      End If
        !
     Case("PROJECT")
        !
        If ( SIC_NARG(0).Gt.2 ) Then
           Write (messageText,*)                                                 &
                & "Usage: SET PROJECT identifier "                               !
           Call PakoMessage(priorityE,severityE,command,messageText)
           Write (messageText,*)                                                 &
                &    " maybe you mean "                                          &
                &  //" SET POINTING azimuthCorrection elevationCorrection "      !
           Call PakoMessage(priorityI,severityI,command,messageText)
        Else
           GV%project = valueC
        End If
        !
     Case("ANGLEUNIT")
        !
        errorAngleUnit = .False.
        !
        Call pakoUmatchKey (                                                     &
             &              keys=angleChoices,                                   &
             &              key=valueC,                                          &
             &              command='SET',                                       &
             &              howto='Start Upper',                                 &
             &              iMatch=iMatch,                                       &
             &              nMatch=nMatch,                                       &
             &              error=errorAngleUnit,                                &
             &              errorCode=errorCode                                  &
             &             )
        !D            Write (6,*) "   valueC:      ->", valueC(1:lenc(valueC)),'<-'
        !D            Write (6,*) "   iMatch:        ", iMatch
        !D            Write (6,*) "   nMatch:        ", nMatch
        !D            Write (6,*) "   errorC:        ", errorC
        !D            Write (6,*) "   errorCode:     ", errorCode
        !
        If (.Not. errorAngleUnit) Then
           !
           If (iMatch.Ne.iArcsec) Then
              errorAngleUnit = .True.
              Write (messageText,*) angleChoices(iMatch)//" IS NOT YET SUPPORTED"  
              Call PakoMessage(priorityE,severityE,command//' angleUnit ',       &
                   &                               messageText)
           End If
           !
!!$         GV%iAU           = iMatch
!!$         !
!!$         GV%angleUnitSetC = angleChoices(iMatch)
!!$         GV%angleUnitSet  = auConv(iMatch)
!!$         GV%angleFactorD  = GV%angleUnitSet/GV%angleUnit
!!$         GV%angleFactorR  = GV%angleUnitSet/GV%angleUnit
!!$         !
!!$         GV%speedUnitSetC = speedChoices(iMatch)
!!$         GV%speedUnitSet  = auConv(iMatch)
!!$         GV%speedFactorD  = GV%speedUnitSet/GV%speedUnit
!!$         GV%speedFactorR  = GV%speedUnitSet/GV%speedUnit
           !
        End If
        !
        error = error .Or. errorAngleUnit
        !
     Case("AUTOMATIC")
        Call SIC_L4(LINE,iOption,iArgument,                                      &
             &                  GV%automatic,.True.,errorL)
        If (.Not.errorL) Then
           If (GV%automatic) Then
              shellCommand = 'ncsMessageSend.py sync state:automatic:on > /dev/null  2>&1 '  !  to work
              !D            shellCommand = 'ncsMessageSend.py sync  test:automatic:on > /dev/null  2>&1 '  !  for tests
              !D             Write (6,*) " shellCommand: "
              !D             Write (6,*)   shellCommand(1:Len_trim(shellCommand))
              ier = system(shellCommand)
              If (ier.Eq.0) Then
                 Write (messageText,*)                                           &
                      &           'automatic:on was sent to coordinator.'
                 Call pakoMessage(priorityW,severityW,command,messageText)
              End If
           Else
              shellCommand = 'ncsMessageSend.py sync state:automatic:off > /dev/null  2>&1 '  !  to work
              !D            shellCommand = 'ncsMessageSend.py sync  test:automatic:off > /dev/null  2>&1 '  !  for tests
              !D             Write (6,*) " shellCommand: "
              !D             Write (6,*)   shellCommand(1:Len_trim(shellCommand))
              ier = system(shellCommand)
              If (ier.Eq.0) Then
                 Write (messageText,*)                                           &
                      &           'automatic:off was sent to coordinator.'
                 Call pakoMessage(priorityW,severityW,command,messageText)
              End If
           End If
           If (ier.Ne.0) Then
              Error = .True.
              Write (messageText,*)                                              &
                   &           'ERROR', ier,                                     &
                   &           '  shellCommand: ncsMessageSend.py '
              Call pakoMessage(priorityE,severityE,command,messageText)
           End If
        End If
        error = error .Or. errorL
        !
     Case("COMMENT")
        !
        !D       Write (6,*) " --> SET COMMENT  "
        !D       Write (6,*) " cInput256:            ", cInput256
        !
        gv%userCommentIsSet = .False.
        gv%userComment      = ""
        !
        If ( len_trim(cInput256) .Ge.1 .And. cInput256.Ne.GPnone ) Then
           !
           gv%userCommentIsSet = .True.
           gv%userComment      = cInput256
           Write (messageText,*) " Comment has been set to: ", gv%userComment
           Call PakoMessage(priorityI,severityI,command,messageText)
           !
        End If
        !
        If ( .Not. gv%userCommentIsSet ) Then
           Write (messageText,*) " Comment is NOT set "  
           Call PakoMessage(priorityI,severityI,command,messageText)
        End If
        !
        !D       Write (6,*) " gv%userCommentIsSet:  ", gv%userCommentIsSet
        !D       Write (6,*) " gv%userComment:       ", gv%userComment
        !
     Case("PURPOSE")
        !
        !D       Write (6,*) " --> SET PURPOSE  "
        !D       Write (6,*) " cInput256:            ", cInput256
        !D       Write (6,*) " purposeChoices:    ", purposeChoices
        !
        gv%purposeIsSet = .False.
        gv%purpose      = ""
        !
        Call pakoUmatchKey (                                                     &
             &              keys=purposeChoices,                                 &
             &              key=cInput256,                                       &
             &              command=command//" Purpose ",                        &
             &              howto='start Upper',                                 &
             &              iMatch=iMatch,                                       & 
             &              nMatch=nMatch,                                       &
             &              error=errorM,                                        &
             &              errorCode=errorCode                                  &
             &             )                                                     !
        !
        !D       Write (6,*) " iMatch:     ", iMatch
        !D       Write (6,*) " nMatch:     ", nMatch
        !D       Write (6,*) " errorM:     ", errorM
        !D       Write (6,*) " errorCode:  ", errorCode
        !
        If ( .Not. errorM ) Then
           !
           If ( len_trim(cInput256) .Ge.1 .And. cInput256.Ne.GPnone ) Then
              !
              gv%purposeIsSet = .True.
              gv%purpose      = purposeChoices(iMatch)
              Write (messageText,*) " Purpose has been set to: ", gv%purpose  
              Call PakoMessage(priorityI,severityI,command,messageText)
              !
           Else
              !
              gv%purposeIsSet = .False.
              gv%purpose      = GPnone
              !
           End If
           !
        End If
        !
        If ( .Not. gv%purposeIsSet ) Then
           Write (messageText,*) " Purpose is NOT set "  
           Call PakoMessage(priorityI,severityI,command,messageText)
        End If
        !
        !D       Write (6,*) " gv%purposeIsSet:  ", gv%purposeIsSet
        !D       Write (6,*) " gv%purpose:       ", gv%purpose
        !
     Case("FOCUS")
        !
        !D       Write (6,*) " "
        !D       Write (6,*) "Focus X: ", isSetFocusCorrectionX, isStandardFocusCorrectionX, GVfCorrX%focusCorrection
        !D       Write (6,*) "Focus Y: ", isSetFocusCorrectionY, isStandardFocusCorrectionY, GVfCorrY%focusCorrection
        !D       Write (6,*) "Focus Z: ", isSetFocusCorrectionZ, isStandardFocusCorrectionZ, GVfCorr%focusCorrection
        !D       Write (6,*) " "
        !D       Write (6,*) "GV%receiverName:  ", GV%receiverName
        !D       Write (6,*) "GV%bolometerName: ", GV%bolometername
        !
        If (SIC_NARG(0).Lt.1 .Or. SIC_NARG(0).Gt.2) Then
           errorNumber = .True.
           Write (messageText,*) &
                & "Usage: SET FOCUS focus"
           Call PakoMessage(priorityE,severityE,command,messageText)
        End If
        !
        vars(iIn)%directionFocus = "Z"                                             ! !! default direction
        !                                                                          ! !! if option /DIR is not present
        !
        Include 'inc/options/optionDirectionFocus.inc'
        !
        !D       Write (6,*) ' after inc/options/optionDirectionFocus.inc   ->'
        !D       Write (6,*) " vars(iIn)%directionFocus:  ", vars(iIn)%directionFocus
        !
        error = error.Or.errorNumber
        !
        iOption   = 0
        iArgument = 2
        If (SIC_PRESENT(iOption,iArgument)) Then
           Call SIC_CH(LINE,iOption,iArgument,cInput,lengthInput,                &
                &              .False.,errorC)
           Call SIC_UPPER(cInput)
           logicalF1 = cInput(1:1) .Eq. 'F'
           If (logicalF1) Then
              Continue
           Else If (cInput(1:1).Ne.'*') Then
              Call SIC_R4(LINE,iOption,iArgument,rInput,.True.,errorR)
              !D             Write (6,*) "   GV%privilege:  ", GV%privilege
              !D             Write (6,*) "   GV%userLevel:  ", GV%userLevel
!!$            Write (6,*) "   GV%iPrivilege:  ", GV%iPrivilege
              !D             Write (6,*) "   GV%iUserLevel:  ", GV%iUserLevel
              !
              If ( .Not. errorR .And. (                                          &
                   &                         GV%privilege.Eq.setPrivilege%staff  &
                   &                    .Or. GV%privilege.Eq.setPrivilege%ncsTeam&
!!$  &                    .Or. GV%iUserLevel.Ge.iGuru                &
                   &                  )                                          &
                   &   ) Then                                                    !
                 !D                Write (6,*) "  "
                 !D                Write (6,*) "  If: privileged: "
                 !
                 If ( rInput.Lt.-999.99 .Or. rInput.Gt.+999.99 ) Then
                    !
                    errorR = .True.
                    Write (messageText,*) rInput, " not allowed " 
                    Call PakoMessage(priorityE,severityE,command,messageText)
                    !
                 End If
                 !
              Else If (.Not. errorR) Then
                 !D                Write (6,*) "  "
                 !D                Write (6,*) "  Else: not privileged: "
                 !D                Write (6,*) "  vars(iIn)%directionFocus:   ", vars(iIn)%directionFocus
                 !D                Write (6,*) "  vars%focusCorrectionX:      ", vars%focusCorrectionX
                 !D                Write (6,*) "  vars%focusCorrectionY:      ", vars%focusCorrectionY
                 !D                Write (6,*) "  vars%focusCorrectionZ:      ", vars%focusCorrection
                 !D                Write (6,*) "  "
                 !!                                                                ! !! TBD: ranges depending on receiver
                 !!                                                                ! !! TBD: logical for standard
                 If (vars(iIn)%directionFocus.Eq."X") Then
                    Call checkR4("SET FOCUS /DIR X",rInput,                      &
                         &           vars%focusCorrectionX,                      &
                         &           errorR)                                     !
                 Else If (vars(iIn)%directionFocus.Eq."Y") Then
                    Call checkR4("SET FOCUS /DIR Y",rInput,                      &
                         &           vars%focusCorrectionY,                      &
                         &           errorR)                                     !
                 Else
                    Call checkR4("SET FOCUS   ",rInput,                          &
                         &           vars%focusCorrection,                       &
                         &           errorR)                                     !
                 End If
              End If
              error = error .Or. errorR
              If (.Not.Error) Then
                 If (vars(iIn)%directionFocus.Eq."X") Then
                    isStandardfocusCorrectionX =                                 &
                         rInput.GE.vars(iStd1)%focusCorrectionX                  &
                         .And. rInput.LE.vars(iStd2)%focusCorrectionX            !
                    isSetFocusCorrectionX = .True.
                    GVfCorrX%focusCorrection = rInput
                 Else If (vars(iIn)%directionFocus.Eq."Y") Then
                    isStandardfocusCorrectionY =                                 &
                         rInput.GE.vars(iStd1)%focusCorrectionY                  &
                         .And. rInput.LE.vars(iStd2)%focusCorrectionY            !
                    isSetFocusCorrectionY = .True.
                    GVfCorrY%focusCorrection = rInput
                 Else
                    isStandardfocusCorrectionZ =                                 &
                         rInput.GE.vars(iStd1)%focusCorrection                   &
                         .And. rInput.LE.vars(iStd2)%focusCorrection             !
                    isSetFocusCorrectionZ = .True.
                    GVfCorr%focusCorrection = rInput
                 End If
              End If
           Else
              rInput = GVfCorr%focusCorrection
           End If
        End If
        !
        !D       Write (6,*) "Focus X: ", isSetFocusCorrectionX, isStandardFocusCorrectionX, GVfCorrX%focusCorrection
        !D       Write (6,*) "Focus Y: ", isSetFocusCorrectionY, isStandardFocusCorrectionY, GVfCorrY%focusCorrection
        !D       Write (6,*) "Focus Z: ", isSetFocusCorrectionZ, isStandardFocusCorrectionZ, GVfCorr%focusCorrection
        !
        error = error .Or. errorR .Or. errorNumber
        !
     Case("DODEBUGMESSAGES")
        !
        ! TBD: handling of defaults, limits, etc.
        iOption   = 0
        iArgument = 2
        If (SIC_PRESENT(iOption,iArgument)) Then
           Call SIC_L4(LINE,iOption,iArgument,                                   &
                &                  GV%doDebugMessages,.True.,errorL)
        End If
        !
        Write (messageText,*) 'doDebugMessages: ', GV%doDebugMessages
        Call PakoMessage(priorityI,severityI,command,messageText)
        !
     Case("DOSUBMIT")
        ! TBD: handling of defaults, limits, etc.
        iOption   = 0
        iArgument = 2
        If (SIC_PRESENT(iOption,iArgument)) Then
           Call SIC_L4(LINE,iOption,iArgument,                                   &
                &                  GV%doSubmit,.True.,errorL)
        End If
        !
        Write (messageText,*) 'Queue. doSubmit: ', GV%doSubmit
        Call PakoMessage(priorityI,severityI,command,messageText)
        !
     Case("DODOPPLERUPDATES")
        !
        ! TBD: handling of defaults, limits, etc.
        iOption   = 0
        iArgument = 2
        If (SIC_PRESENT(iOption,iArgument)) Then
           Call SIC_L4(LINE,iOption,iArgument,                                   &
                &                  GV%doDopplerUpdates,.True.,errorL)
        End If
        !
        Write (messageText,*) 'doDopplerUpdates: ', GV%doDopplerUpdates
        Call PakoMessage(priorityI,severityI,command,messageText)
        !
     Case("DOXMLOBSERVINGMODE")
        !
        ! TBD: handling of defaults, limits, etc.
        iOption   = 0
        iArgument = 2
        If (SIC_PRESENT(iOption,iArgument)) Then
           Call SIC_L4(LINE,iOption,iArgument,                                   &
                &                  GV%doXmlObservingMode,.True.,errorL)
        End If
        !
        Write (messageText,*) 'doXmlObservingMode: ', GV%doXmlObservingMode
        Call PakoMessage(priorityI,severityI,command,messageText)
        !
!!$      Write (messageText,*) "is not yet supported"
!!$      Call PakoMessage(priorityW,severityW,command//" doXmlObservingMode",    &
!!$           &                     messageText)
        !
     Case("EMIRCHECK")
        !
        errorLimitCheck = .False.
        Call pakoUmatchKeyNew (                                                  &
             &              keys=setLimitCheckChoices,                           &
             &              key=valueC,                                          &
             &              command='SET',                                       &
             &              howto='Exact',                                       &
             &              iMatch=iMatch,                                       &
             &              nMatch=nMatch,                                       &
             &              error=errorLimitCheck,                               &
             &              errorCode=errorCode                                  &
             &              )                                                    !
        !
        error = error .Or. errorLimitCheck
        If (.Not. error) Then
           GV%EMIRcheck  = setLimitCheckChoices(iMatch)
           GV%iEMIRcheck = iMatch
        Else
           Write (messageText,*) "exact match is required to relax!"
           Call PakoMessage(priorityE,severityE,"SET EMIRcheck",messageText)
           GV%EMIRcheck  = setLimitCheck%strict
           GV%iEMIRcheck = iStrict
        End If
        !
        !D       Write (6,*) "   GV%iEMIRcheck: ", GV%iEMIRcheck
        Write (messageText,*) GV%EMIRcheck
        Call PakoMessage(priorityI,severityI,"SET EMIRcheck",messageText)
        !
        Write (messageText,*) "USE AT YOUR OWN RISK!"
        Call PakoMessage(priorityW,severityW,"SET EMIRcheck",messageText)
        !
     Case("LEVEL")
        iOption   = 0
        iArgument = 2
        If (SIC_PRESENT(iOption,iArgument)) Then
           Call SIC_I4(LINE,iOption,iArgument,iInput,.True.,errorI)
           If (.Not. errorI) Then
              GV%iPstdio = Min(Max(0,iInput),9)
              Call pakoMessage_level(GV%iPstdio)
           End If
        End If
        iArgument = 3
        If (SIC_PRESENT(iOption,iArgument)) Then              
           Call SIC_I4(LINE,iOption,iArgument,iInput,.True.,errorI)
           If (.Not. errorI) Then
              GV%iPfile = Min(Max(0,iInput),9)
              Call pakoMessage_level(GV%iPstdio,GV%iPfile)
           End If
        End If
        !
     Case("LIMITCHECK")
        !
        If (    GV%privilege.Eq.setPrivilege%privileged                          &        
             &  .Or.GV%privilege.Eq.setPrivilege%staff                           &
             &  .Or.GV%privilege.Eq.setPrivilege%ncsTeam                         &
             &  .Or.GV%privilege.Eq.setPrivilege%bolometerPool                   &
             &  .Or.GV%userLevel.Eq.setUserLevel%experienced                     &
             &  .Or.GV%userLevel.Eq.setUserLevel%guru                            &
             &  .Or.GV%userLevel.Eq.setUserLevel%primadonna                      &
             !!       &  .Or.GV%privilege.Eq.setPrivilege%GISMO                  &
             &  ) Then
           !
           errorLimitCheck = .False.
           Call pakoUmatchKeyNew (                                               &
                &              keys=setLimitCheckChoices,                        &
                &              key=valueC,                                       &
                &              command='SET',                                    &
                &              howto='Exact',                                    &
                &              iMatch=iMatch,                                    &
                &              nMatch=nMatch,                                    &
                &              error=errorLimitCheck,                            &
                &              errorCode=errorCode                               &
                &              )                                                 !
           !
           error = error .Or. errorLimitCheck
           If (.Not. error) Then
              GV%limitCheck             =  setLimitCheckChoices(iMatch)
              GV%iLimitCheck            =  iMatch
           Else
              Write (messageText,*) "exact match is required to relax!"
              Call PakoMessage(priorityE,severityE,"SET LimitCheck",messageText)
              GV%limitCheck  = setLimitCheck%strict
              GV%iLimitCheck = iStrict
           End If
           pakoLimitsGV%limitCheck   =  GV%LimitCheck
           pakoLimitsGV%iLimitCheck  =  GV%iLimitCheck
           !D          Write (6,*) " pakoLimitsGV%limitCheck:     ", pakoLimitsGV%limitCheck
           !D          Write (6,*) " pakoLimitsGV%iLimitCheck:    ", pakoLimitsGV%iLimitCheck
           !
           !D       Write (6,*) "   GV%iLimitCheck: ", GV%iLimitCheck
           Write (messageText,*) GV%limitCheck
           Call PakoMessage(priorityI,severityI,"SET LimitCheck",messageText)
           !
           Write (messageText,*) "USE AT YOUR OWN RISK!"
           Call PakoMessage(priorityW,severityW,"SET LimitCheck",messageText)
           !
        Else
           !
           errorLimitCheck = .True.
           error = error .Or. errorLimitCheck
           !
           GV%limitCheck  = setLimitCheck%strict
           GV%iLimitCheck = iStrict
           !
           Write (messageText,*) "needs privilege"
           Call PakoMessage(priorityE,severityE,"SET LimitCheck",messageText)
           !
        End If
        !
     Case("MATCHSOURCE")
        !
        !D         Write (6,*) "   Case MATCHSOURCE"
        !D         Write (6,*) "      GV%privilege:      ", GV%privilege
        !D         Write (6,*) "      GV%iPrivilege:     ", GV%iPrivilege
        !D         Write (6,*) "      GV%userLevel:      ", GV%userLevel
        !D         Write (6,*) "      GV%iUserLevel:     ", GV%iUserLevel
        !D         Write (6,*) "      "
        !
!!$        If (    GV%privilege.Eq.setPrivilege%privileged                          &
!!$             &  .Or.GV%privilege.Eq.setPrivilege%staff                           &
!!$       &  .Or.GV%privilege.Eq.setPrivilege%VLBI                               &
!!$             &  .Or.GV%privilege.Eq.setPrivilege%ncsTeam                         &
!!$             &  ) Then                                                           !
!!$           !
        !
        If       (      GV%iPrivilege.GE.iPrivileged                             &
             &     .Or. GV%iUserLevel.GE.iExperienced                            & 
             &   ) Then                                                          !
           !
           errorLimitCheck = .False.
           Call pakoUmatchKeyNew (                                               &
                &              keys=setMatchSourceChoices,                       &
                &              key=valueC,                                       &
                &              command='SET',                                    &
                &              howto='Exact',                                    &
                &              iMatch=iMatch,                                    &
                &              nMatch=nMatch,                                    &
                &              error=errorLimitCheck,                            &
                &              errorCode=errorCode                               &
                &              )                                                 !
           !
           error = error .Or. errorLimitCheck
           If (.Not. error) Then
              GV%Matchsource  = setMatchSourceChoices(iMatch)
              GV%iMatchSource = iMatch
           Else
              Write (messageText,*) "exact match is required !"
              Call PakoMessage(priorityE,severityE,"SET MatchSource",messageText)
              GV%MatchSource  = setMatchSource%exact
              GV%iMatchSource = iExact
           End If
           !
           Write (messageText,*) GV%MatchSource
           Call PakoMessage(priorityI,severityI,"SET MatchSource",messageText)
           !
           Write (messageText,*) "USE AT YOUR OWN RISK!"
           Call PakoMessage(priorityW,severityW,"SET MatchSource",messageText)
           !
        Else
           !
           errorLimitCheck = .True.
           error = error .Or. errorLimitCheck
           !
           GV%limitCheck  = setLimitCheck%strict
           GV%iLimitCheck = iStrict
           !
           Write (messageText,*) "needs privilege"
           Call PakoMessage(priorityE,severityE,"SET MatchSource",messageText)
           !
        End If
        !
     Case("PLOTSTYLE")
        errorPlotStyle = .False.
        Call pakoUmatchKey (                                                     &
             &              keys=setPlotChoices,                                 &
             &              key=valueC,                                          &
             &              command='SET',                                       &
             &              howto='Start Upper',                                 &
             &              iMatch=iMatch,                                       &
             &              nMatch=nMatch,                                       &
             &              error=errorPlotStyle,                                &
             &              errorCode=errorCode                                  &
             &             )
        !
        error = error .Or. errorPlotStyle
        If (.Not. error) Then
           GV%plotStyle = setPlotChoices(iMatch)
        End If
        !
        Write (messageText,*) "plotStyle: ", GV%plotStyle
        Call PakoMessage(priorityI,severityI,command,messageText)
        !
        Write (messageText,*) "is not yet supported / only paritally supported"
        Call PakoMessage(priorityW,severityW,command//" plotStyle",messageText)
        !
     Case("PRIVILEGE")
        errorPrivilege = .False.
        Call pakoUmatchKeyNew (                                                  &
             &              keys=setPrivilegeChoices,                            &
             &              key=valueC,                                          &
             &              command='SET',                                       &
             &              howto='Exact',                                       &
             &              iMatch=iMatch,                                       &
             &              nMatch=nMatch,                                       &
             &              error=errorPrivilege,                                &
             &              errorCode=errorCode                                  &
             &             )
        !
        error = error .Or. errorPrivilege
        If (.Not. error) Then
           GV%privilege            = setPrivilegeChoices(iMatch)
           GV%iPrivilege           = iMatch
        Else
           Write (messageText,*) "exact match is required to get privileges!"
           Call PakoMessage(priorityE,severityE,"SET Privilege",messageText)
           GV%privilege   =  setPrivilege%user
           GV%iPrivilege  =  iUser
           GV%userLevel   =  setUserLevel%normal
           GV%iUserLevel  =  iNormal
        End If
        pakoLimitsGV%privilege  = GV%privilege 
        !D       Write (6,*) " pakoLimitsGV%privilege:     ", pakoLimitsGV%privilege
        !
        Write (messageText,*) GV%privilege
        Call PakoMessage(priorityI,severityI,"SET Privilege",messageText)
        !
        !D         Write (6,*) "            GV%iPrivilege: ", GV%iPrivilege
        !
        !D       Write (messageText,*) "is not yet supported"
        !D       Call PakoMessage(priorityW,severityW,"SET Privilege",messageText)
        !
     Case("POINTING")
        !
        If (SIC_NARG(0).Lt.2 .Or. SIC_NARG(0).Gt.3) Then
           Write (messageText,*) &
                & "Usage: SET POINTING azimuthCorrection [elevationCorrection] "
           Call PakoMessage(priorityE,severityE,command,messageText)
        End If
        !
        iOption   = 0
        iArgument = 2
        If (SIC_PRESENT(iOption,iArgument)) Then
           Call SIC_CH(LINE,iOption,iArgument,cInput,lengthInput,                &
                &              .False.,errorC)                                   !
           Call SIC_UPPER(cInput)
           logicalF1 = cInput(1:1) .Eq. 'F'
           If (logicalF1) Then
              Continue
           Else If (cInput(1:1).Ne.'*') Then
              Call SIC_R4(LINE,iOption,iArgument,rInput,.True.,errorR)
              If (.Not. errorR) Then
                 Call checkR4co(command,option,rInput,                           &
                      &           vars%azimuthCorrection,                        &
                      &           errorR)                                        !
              End If
              error = error .Or. errorR
              If (.Not.Error) Then
                 isStandardAzimuthCorrection =                                   &
                      rInput.GE.vars(iStd1)%AzimuthCorrection                    &
                      .And. rInput.LE.vars(iStd2)%AzimuthCorrection              !
                 GVpCorr%azimuthCorrection= rInput
              End If
           Else
              rInput = GVpCorr%azimuthCorrection
           End If
        End If
        iArgument = 3
        If (SIC_PRESENT(iOption,iArgument)) Then              
           Call SIC_CH(LINE,iOption,iArgument,cInput,lengthInput,                &
                &              .False.,errorC)                                   !
           Call SIC_UPPER(cInput)
           logicalF2 = cInput(1:1) .Eq. 'F'
           If (logicalF2) Then
              Continue
           Else If (cInput(1:1).Ne.'*') Then
              Call SIC_R4(LINE,iOption,iArgument,rInput2,.True.,errorR)
              If (.Not. errorR) Then
                 Call checkR4co(command,option,rInput2,                          &
                      &           vars%elevationCorrection,                      &
                      &           errorR)                                        !
              End If
              error = error .Or. errorR
              If (.Not.Error) Then
                 isStandardElevationCorrection =                                 &
                      rInput2.GE.vars(iStd1)%ElevationCorrection                 &
                      .And. rInput2.LE.vars(iStd2)%ElevationCorrection           !
                 GVpCorr%elevationCorrection= rInput2
              End If
           Else
              rInput2 = GVpCorr%elevationCorrection
           End If
        End If
        !
        !D       Write (6,*) "POINTING azimuthCorrection: ", isStandardAzimuthCorrection, GVpCorr%azimuthCorrection
        !D       Write (6,*) "POINTING elevationCorrection: ", isStandardElevationCorrection, GVpCorr%elevationCorrection
        !
        !! obsolete: ier = sic_getlun(iunit)
        !
        iUnit = ioUnit%read
        !
        ! TBD: XML to nml translation
        ! TBD: check for presence of python utilities etc.
        If (logicalF1 .Or. logicalF2) Then
           Open (unit=iUnit, file='pointing.nml',                                &
                & delim='APOSTROPHE',  action='read', status='old',              &
                & iostat=ier)
           If (ier .Eq. 0) Then 
              pCorr = pCorrDefault
              Read (unit=iunit, NML=pCorrNML, iostat=ier)
           End If
           If (ier .Ne. 0) Then
              messageText =                                                      &
                   &        "Could not read file: pointing.nml"
              Call PakoMessage(priorityE,severityE,command//' POINTING',         &
                   &           messageText)
              error = .True.
           Else
              GVpCorr = pCorr
              If (.Not.logicalF1) GVpCorr%azimuthCorrection = rInput
              If (.Not.logicalF2) GVpCorr%elevationCorrection = rInput2
!!$ Write (6,*) '      azimuth                 ', GVpCorr%azimuth           
!!$ Write (6,*) '      elevation               ', GVpCorr%elevation         
!!$ Write (6,*) '      pointingP1              ', GVpCorr%pointingP(1)
!!$ Write (6,*) '      pointingP2              ', GVpCorr%pointingP(2)
!!$ Write (6,*) '      pointingP7              ', GVpCorr%pointingP(7)
!!$ Write (6,*) '      azimuthCorrection       ', GVpCorr%azimuthCorrection       
!!$ Write (6,*) '      azimuthCorrectionError  ', GVpCorr%azimuthCorrectionError  
!!$ Write (6,*) '      elevationCorrection     ', GVpCorr%elevationCorrection     
!!$ Write (6,*) '      elevationCorrectionError', GVpCorr%elevationCorrectionError
           End If
           Close (unit=iunit)
        End If
        Write (messageText,*) 'Pointing. azimuthCorrection:   ',                 &
             &                 GVpCorr%azimuthCorrection
        Call PakoMessage(priorityI,severityI,command,messageText)
        Write (messageText,*) 'Pointing. elevationCorrection: ',                 &
             &                 GVpCorr%elevationCorrection
        Call PakoMessage(priorityI,severityI,command,messageText)
        !
     Case("SLOWRATEAMD")
        !
        !D       Write (6,*) "      -> parametersSetKeywordValue: Case         ", set%slowRateAMD
        !D       Write (6,*) "                                    GV%privilege ", GV%privilege
        !
        If (        GV%privilege.Eq.setPrivilege%bolometerPool                   &
!!$             & .Or. GV%privilege.Eq.setPrivilege%GISMO                           &
             & .Or. GV%privilege.Eq.setPrivilege%staff                           &
             & .Or. GV%privilege.Eq.setPrivilege%ncsTeam ) Then                  !
           !
           If (SIC_NARG(0).Lt.1 .Or. SIC_NARG(0).Gt.2) Then
              errorNumber = .True.
              Write (messageText,*) &
                   & "Usage: SET SLOWRATEAMD [1|2|4|8]"
              Call PakoMessage(priorityE,severityE,command,messageText)
           End If
           !
           iOption   = 0
           iArgument = 2
           If (SIC_PRESENT(iOption,iArgument)) Then
              Call SIC_CH(LINE,iOption,iArgument,cInput,lengthInput,             &
                   &              .False.,errorC)                                !
              Call SIC_UPPER(cInput)
              If (cInput(1:1).Ne.'*') Then
                 Call SIC_R4(LINE,iOption,iArgument,rInput,.True.,errorR)
                 If (.Not. errorR) Then
                    Call checkR4co(command,option,rInput,                        &
                         &           vars%slowRateAMD,                           &
                         &           errorR)                                     !
                 End If
                 error = error .Or. errorR
                 If (.Not.Error) Then
                    If      (rInput.Lt.2) Then
                       GV%slowRateAMD = 1
                    Else If (rInput.Lt.4) Then
                       GV%slowRateAMD = 2
                    Else If (rInput.Lt.8) Then
                       GV%slowRateAMD = 4
                    Else 
                       GV%slowRateAMD = 8
                    End If
                 Else
                    Write (messageText,*) "Usage: SET SLOWRATEAMD [1|2|4|8]"
                    Call PakoMessage(priorityE,severityE,command,messageText)
                 End If
              Else
                 rInput = GV%slowRateAMD
              End If
           End If
           !
           error = error .Or. errorR .Or. errorNumber
           !
           Write (messageText,*) "slowRateAMD is now ", GV%slowRateAMD
           Call PakoMessage(priorityI,severityI,command,messageText)
           !
        Else
           GV%slowRateAMD = 1
           Write (messageText,*) "SLOWRATEAMD requires privilege"
           Call PakoMessage(priorityE,severityE,command,messageText)
        End If
        !
     Case("TESTMODE")
        !
        ! TBD: handling of defaults, limits, etc.
        iOption   = 0
        iArgument = 2
        If (SIC_PRESENT(iOption,iArgument)) Then
           Call SIC_CH(LINE,iOption,iArgument,                                   &
                &        cInputLong,lengthInput,.True.,errorC)                   !
        End If
        !
        !!D Write (6,*) "         cInputLong:   -->", cInputLong,  "<--"
        !
        If (  .Not.errorC  ) Then
           GV%testMode  =  cInputLong(1:lengthInput)
        End If
        !
        Write (messageText,*) 'testMode: ', GV%testMode
        Call PakoMessage(priorityI,severityI,command,messageText)
        !
     Case("TOPOLOGY")
        errorTopology = .False.
        Call pakoUmatchKey (                                                     &
             &              keys=topologyChoices,                                &
             &              key=valueC,                                          &
             &              command='SET',                                       &
             &              howto='Start Upper',                                 &
             &              iMatch=iMatch,                                       &
             &              nMatch=nMatch,                                       &
             &              error=errorTopology,                                 &
             &              errorCode=errorCode                                  &
             &             )
        !D            Write (6,*) "   valueC:      ->", valueC(1:lenc(valueC)),'<-'
        !D            Write (6,*) "   iMatch:        ", iMatch
        !D            Write (6,*) "   nMatch:        ", nMatch
        !D            Write (6,*) "   errorC:        ", errorC
        !D            Write (6,*) "   errorCode:     ", errorCode
        If  (iMatch.Lt.iLOW .Or. iMatch.Gt.iHIGH) Then
           errorTopology =  .True.
           Write (messageText,*) valueC(1:lenc(valueC)), " not yet supported"
           Call PakoMessage(priorityE,severityE,command//' TOPOLOGY',messageText)
        End If
        error = error .Or. errorTopology
        If (.Not. error) Then
           GV%topology = valueC
        End If
        !
     Case("TRANSITIONACCELERATION")
        ! 
        If (        GV%privilege.Eq.setPrivilege%bolometerPool                   &
             & .Or. GV%privilege.Eq.setPrivilege%staff                           &
             & .Or. GV%privilege.Eq.setPrivilege%ncsTeam                         &
             & ) Then                                                            !
           iOption   = 0
           iArgument = 2
           If (SIC_PRESENT(iOption,iArgument)) Then
              Call SIC_R4(LINE,iOption,iArgument,rInput,.True.,errorR)               
              If (.Not. errorR) Then                                                 
                 Call checkR4co(command,option,rInput,                           &
                      &           vars%transitionAcceleration,                   &
                      &           errorR)                                        !
              End If
              error = error .Or. errorR
              If (.Not.Error) Then
                 GV%transitionAcceleration = rInput
                 vars(iValue)%transitionAcceleration = rInput
              End If
           End If
           Write (messageText,'(F6.3,A)') GV%transitionAcceleration, " [deg/s^2]"
           l = len_trim(command)
           Call PakoMessage(priorityI,severityI,                                 &
                &                    command(1:l)//" transitionAcceleration",    &
                &                                             messageText)       !
        Else
           Write (messageText,'(A)') " transitionAcceleration not available: "   &
                &                  //"needs privilege"                           !
           l = len_trim(command)
           Call PakoMessage(priorityI,severityI,                                 &
                &                    command(1:l),                               &
                &                                             messageText)       !
        End If
        !
     Case("USERLEVEL")
        !
        errorUserLevel = .False.
        !
!!$      If ( .Not. (        GV%privilege.Eq.setPrivilege%privileged             &
!!$           &         .Or. GV%privilege.Eq.setPrivilege%staff                  &
!!$           &         .Or. GV%privilege.Eq.setPrivilege%ncsTeam                &
!!$           &     )   ) Then                                                   !
!!$         !
!!$         errorUserLevel = .True.
!!$         Write (messageText,'(A)') " userLevel not available: "               &
!!$              &                  //"needs privilege"                          !
!!$         l = len_trim(command)
!!$         Call PakoMessage(priorityE,severityE,command(1:l),messageText)
!!$         !
!!$      End If
!!$      !
!!$      error = error .Or. errorUserLevel
        !
        If (.Not. Error) Then
           Call pakoUmatchKeyNew (                                               &
                &              keys=setUserLevelChoices,                         &
                &              key=valueC,                                       &
                &              command='SET',                                    &
                &              howto='Exact',                                    &
                &              iMatch=iMatch,                                    &
                &              nMatch=nMatch,                                    &
                &              error=errorUserLevel,                             &
                &              errorCode=errorCode                               &
                &             )                                                  !
           !
           If (.Not. errorUserLevel) Then
              GV%userLevel             =  setUserLevelChoices(iMatch)
              GV%iUserLevel            =  iMatch
           Else
              Write (messageText,*) "exact match is required to set userLevel!"
              Call PakoMessage(priorityE,severityE,"SET UserLevel",messageText)
              GV%userLevel   =  setUserLevel%beginner
              GV%iUserLevel  =  iBeginner
           End If
           pakoLimitsGV%userLevel   =  GV%UserLevel
           pakoLimitsGV%iUserLevel  =  GV%iUserLevel
           !D          Write (6,*) " pakoLimitsGV%userLevel:     ", pakoLimitsGV%userLevel
           !D          Write (6,*) " pakoLimitsGV%iUserLevel:    ", pakoLimitsGV%iUserLevel
           !
           Write (messageText,*) "USE AT YOUR OWN RISK!"
           Call PakoMessage(priorityW,severityW,"SET UserLevel",messageText)
           Write (messageText,*) GV%userLevel
           Call PakoMessage(priorityI,severityI,"SET UserLevel",messageText)
           !D          Write (6,*) "     GV%iUserLevel: ", GV%iUserLevel
        End If
        !
        error = error .Or. errorUserLevel      
        !
     Case("2NDROTATION")
        ! 
        If ( .Not. (        GV%privilege.Eq.setPrivilege%bolometerPool           &
             &         .Or. GV%privilege.Eq.setPrivilege%staff                   &
             &         .Or. GV%privilege.Eq.setPrivilege%ncsTeam                 &
             &     )   ) Then                                                    !
           !
           errorL = .True.
           Write (messageText,'(A)') " 2ndRotation not available: "              &
                &                  //"needs privilege"                           !
           l = len_trim(command)
           Call PakoMessage(priorityE,severityE,command(1:l),messageText)
           !
        End If
        !
        error = error .Or. errorL
        !
        !  ** check for receiver. NOTE: indirectly; can't use queryReceiver
        !
        !D       Write (6,*) "   --> setKeywordValue.inc: GV%receiverName:  -->", GV%receiverName,  "<--" 
        !D       Write (6,*) "   --> setKeywordValue.inc: GV%bolometerName: -->", GV%bolometerName, "<--" 
        !
        If (          GV%privilege.Eq.setPrivilege%bolometerPool                 &
             &  .And. GV%receiverName .Ne. rec%Bolo) Then                        !
           !
           errorL = .True.
           Write (messageText,'(A)') "2ndRotation only supported with "          &
                &                  //"MAMBO bolometer"                           !
           l = len_trim(command)
           Call PakoMessage(priorityE,severityE,command(1:l),messageText)
           !
        End If
        !
        error = error .Or. errorL
        !
        If (.Not. errorL) Then
           !
           iOption   = 0
           iArgument = 2
           If (SIC_PRESENT(iOption,iArgument)) Then
              Call SIC_R4(LINE,iOption,iArgument,rInput,.True.,errorR)                   
              If (.Not. errorR) Then                                                     
                 Call checkR4co(command,option,rInput,                           &  
                      &           vars%secondaryRotation,                        &
                      &           errorR)                                        !
              End If
              error = error .Or. errorR
              If (.Not.Error) Then
                 GV%secondaryRotation = rInput
                 vars(iValue)%secondaryRotation = rInput
                 GV%notReadySecondaryRafterOM = .True.
                 GV%notReadyRXafterSecondary  = .False.
                 valueText = GV%observingModePako
                 Call SIC_UPPER(valueText)
                 Write (messageText,*)                                           & 
                      &         'Please specify (again) ',                       &
                      &         ' Observing Mode, e.g., ',                       &
                      &         valueText,                                       &
                      &         ' '                                              !
                 l = len_trim(command)
                 Call pakoMessage(priorityW,severityW,                           &
                      &           command(1:l)//" 2ndRotation", messageText)     !
              End If
           End If
           Write (messageText,'(F7.3,A)') GV%secondaryRotation, " [deg]"
           l = len_trim(command)
           Call PakoMessage(priorityI,severityI,command(1:l)//" 2ndRotation",    &
                &                                             messageText)       !
           !
        End If
        !
     End Select
  End If
  !
  error = error .Or. errorC
  !
