!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cube_types
  use cubedag_types
  use cubeio_types
  use cubetuple_messaging
  !
  public :: cubetuple_t,cubetuple_naccess,cubetuple_trans_t ! [private]
  public :: cube_t                                          ! [public]
  public :: code_trans_none,code_trans_memo,code_trans_disk
  public :: cubetuple_trans_reset,cubetuple_cube_ptr
  private
  !
  integer(kind=code_k), parameter :: code_trans_none=0
  integer(kind=code_k), parameter :: code_trans_memo=1
  integer(kind=code_k), parameter :: code_trans_disk=2
  !
  ! Description of the pending transposition, if relevant
  type cubetuple_trans_t
    ! ZZZ This type will become useless once the cube_t provides directly
    !     its own cubedag_tuple_t. ZZZ I am not so sure now...
    integer(kind=code_k)  :: do=code_trans_none    ! Which transposition is enabled?
    integer(kind=4)       :: from=0   ! From this cube
    integer(kind=4)       :: to=0     ! To this cube
    character(len=trop_l) :: code=''  ! Transposition string code
  end type cubetuple_trans_t
  !
  integer(kind=4), parameter :: cubetuple_naccess=2
  type cubetuple_t
    ! type(???)                                      ! Description of the N cubes, methods, etc
    type(cubeio_cube_t)          :: cube(cubetuple_naccess)
    type(cubeio_cube_t), pointer :: current=>null()  ! Current access in use
    type(cubetuple_trans_t)      :: trans            ! [private?]  Transposition description
  contains
    procedure :: order   => cubetuple_get_order
    procedure :: access  => cubetuple_get_access
    procedure :: iscplx  => cubetuple_get_iscplx
    procedure :: haskind => cubetuple_has_filekind
    procedure :: nbytes  => cubetuple_get_nbytes
    procedure :: ndata   => cubetuple_get_ndata
    procedure :: nentry  => cubetuple_get_nentry
    procedure :: memsize => cubetuple_get_memsize
    procedure :: close   => cubetuple_close
    procedure :: free    => cubetuple_free
    final     :: cubetuple_final
  end type cubetuple_t
  !
  type, extends(cubedag_node_object_t) :: cube_t
    type(cubetuple_t)           :: tuple  ! [private]
    type(cube_header_t)         :: head   ! [public]  User friendly cube description
    type(cube_define_t)         :: prog   ! [private] program request
    type(cube_setup_t), pointer :: user   ! [private] user    request
  contains
    procedure :: order   => cube_get_order
    procedure :: access  => cube_get_access
    procedure :: iscplx  => cube_get_iscplx
    procedure :: haskind => cube_has_filekind
    procedure :: nbytes  => cube_get_nbytes
    procedure :: ndata   => cube_get_ndata
    procedure :: nentry  => cube_get_nentry
    procedure :: close   => cube_close
    procedure :: free    => cube_free
    final     :: cube_final
  end type cube_t
  !
contains
  !
  subroutine cubetuple_trans_reset(trans,error)
    type(cubetuple_trans_t), intent(out)   :: trans
    logical,                 intent(inout) :: error
    !
    ! All done by intent(out)
    return
  end subroutine cubetuple_trans_reset
  !
  function cube_get_order(cub)
    !-------------------------------------------------------------------
    ! Return the CURRENT cube order
    !-------------------------------------------------------------------
    integer(kind=code_k) :: cube_get_order
    class(cube_t), intent(in) :: cub
    cube_get_order = cub%tuple%order()
  end function cube_get_order
  !
  function cubetuple_get_order(tuple)
    !-------------------------------------------------------------------
    ! Return the CURRENT cube order
    !-------------------------------------------------------------------
    integer(kind=code_k) :: cubetuple_get_order
    class(cubetuple_t), intent(in) :: tuple
    if (.not.associated(tuple%current)) then
      cubetuple_get_order = code_null
    else
      cubetuple_get_order = tuple%current%order()
    endif
  end function cubetuple_get_order
  !
  function cube_get_access(cub)
    !-------------------------------------------------------------------
    ! Return the CURRENT access mode.
    !-------------------------------------------------------------------
    integer(kind=code_k) :: cube_get_access
    class(cube_t), intent(in) :: cub
    cube_get_access = cub%tuple%access()
  end function cube_get_access
  !
  function cubetuple_get_access(tuple)
    !-------------------------------------------------------------------
    ! Return the CURRENT access mode.
    !-------------------------------------------------------------------
    integer(kind=code_k) :: cubetuple_get_access
    class(cubetuple_t), intent(in) :: tuple
    if (.not.associated(tuple%current)) then
      cubetuple_get_access = code_null
    else
      cubetuple_get_access = tuple%current%access()
    endif
  end function cubetuple_get_access
  !
  function cube_get_iscplx(cub)
    !-------------------------------------------------------------------
    ! Return .true. if the cube data is complex*4
    !-------------------------------------------------------------------
    logical :: cube_get_iscplx
    class(cube_t), intent(in) :: cub
    cube_get_iscplx = cub%tuple%iscplx()
  end function cube_get_iscplx
  !
  function cubetuple_get_iscplx(tuple)
    !-------------------------------------------------------------------
    ! Return .true. if the tuple data is complex*4
    !-------------------------------------------------------------------
    logical :: cubetuple_get_iscplx
    class(cubetuple_t), intent(in) :: tuple
    if (.not.associated(tuple%current)) then
      cubetuple_get_iscplx = .false.
    else
      cubetuple_get_iscplx = tuple%current%iscplx()
    endif
  end function cubetuple_get_iscplx
  !
  function cube_has_filekind(cub,code_filekind)
    !-------------------------------------------------------------------
    ! Return .true. if the cube provides the given kind description
    !-------------------------------------------------------------------
    logical :: cube_has_filekind
    class(cube_t),        intent(in) :: cub
    integer(kind=code_k), intent(in) :: code_filekind
    cube_has_filekind = cub%tuple%haskind(code_filekind)
  end function cube_has_filekind
  !
  function cubetuple_has_filekind(tuple,code_filekind)
    !-------------------------------------------------------------------
    ! Return .true. if the tuple provides the given kind description
    !-------------------------------------------------------------------
    logical :: cubetuple_has_filekind
    class(cubetuple_t),   intent(in) :: tuple
    integer(kind=code_k), intent(in) :: code_filekind
    if (.not.associated(tuple%current)) then
      cubetuple_has_filekind = .false.
    else
      cubetuple_has_filekind = tuple%current%haskind(code_filekind)
    endif
  end function cubetuple_has_filekind
  !
  function cube_get_nbytes(cub)
    !-------------------------------------------------------------------
    ! Return the number of bytes per data value
    !-------------------------------------------------------------------
    integer(kind=4) :: cube_get_nbytes
    class(cube_t), intent(in) :: cub
    cube_get_nbytes = cub%tuple%nbytes()
  end function cube_get_nbytes
  !
  function cubetuple_get_nbytes(tuple)
    !-------------------------------------------------------------------
    ! Return the number of bytes per data value
    !-------------------------------------------------------------------
    integer(kind=4) :: cubetuple_get_nbytes
    class(cubetuple_t), intent(in) :: tuple
    if (.not.associated(tuple%current)) then
      cubetuple_get_nbytes = 0
    else
      cubetuple_get_nbytes = tuple%current%nbytes()
    endif
  end function cubetuple_get_nbytes
  !
  function cube_get_ndata(cub)
    !-------------------------------------------------------------------
    ! Return the number of data values in the cube
    !-------------------------------------------------------------------
    integer(kind=data_k) :: cube_get_ndata
    class(cube_t), intent(in) :: cub
    cube_get_ndata = cub%tuple%ndata()
  end function cube_get_ndata
  !
  function cubetuple_get_ndata(tuple)
    !-------------------------------------------------------------------
    ! Return the number of data values
    !-------------------------------------------------------------------
    integer(kind=data_k) :: cubetuple_get_ndata
    class(cubetuple_t), intent(in) :: tuple
    if (.not.associated(tuple%current)) then
      cubetuple_get_ndata = 0
    else
      cubetuple_get_ndata = tuple%current%ndata()
    endif
  end function cubetuple_get_ndata
  !
  function cube_get_nentry(cub)
    !-------------------------------------------------------------------
    ! Return the number of entries (Nchan/NPix) for the CURRENT access
    ! mode.
    !-------------------------------------------------------------------
    integer(kind=entr_k) :: cube_get_nentry
    class(cube_t), intent(in) :: cub
    cube_get_nentry = cub%tuple%nentry()
  end function cube_get_nentry
  !
  function cubetuple_get_nentry(tuple)
    !-------------------------------------------------------------------
    ! Return the number of entries (Nchan/NPix) for the CURRENT access
    ! mode.
    !-------------------------------------------------------------------
    integer(kind=entr_k) :: cubetuple_get_nentry
    class(cubetuple_t), intent(in) :: tuple
    if (.not.associated(tuple%current)) then
      cubetuple_get_nentry = 0
    else
      cubetuple_get_nentry = tuple%current%nentry()
    endif
  end function cubetuple_get_nentry
  !
  function cubetuple_get_memsize(tuple)
    !-------------------------------------------------------------------
    ! Return the memory footprint in bytes
    !-------------------------------------------------------------------
    integer(kind=size_length) :: cubetuple_get_memsize
    class(cubetuple_t), intent(in) :: tuple
    !
    integer(kind=4) :: iaccess
    !
    cubetuple_get_memsize = 0
    do iaccess=1,cubetuple_naccess
      cubetuple_get_memsize = cubetuple_get_memsize + tuple%cube(iaccess)%memsize()
    enddo
  end function cubetuple_get_memsize
  !
  subroutine cube_close(cub,error)
    !---------------------------------------------------------------------
    ! GIO-close a 'cube_t' instance. This is worth calling this subroutine
    ! as GIO slots are a limited ressource
    !---------------------------------------------------------------------
    class(cube_t), intent(inout) :: cub
    logical,       intent(inout) :: error
    !
    call cub%tuple%close(error)
    if (error)  return
  end subroutine cube_close
  !
  subroutine cubetuple_close(tuple,error)
    !---------------------------------------------------------------------
    ! GIO-close a 'cubetuple_t' instance. This is worth calling this
    ! subroutine as GIO slots are a limited ressource
    !---------------------------------------------------------------------
    class(cubetuple_t), intent(inout) :: tuple
    logical,            intent(inout) :: error
    ! Local
    integer(kind=4) :: iaccess
    !
    do iaccess=1,cubetuple_naccess
      call tuple%cube(iaccess)%close(error)
      if (error)  continue
    enddo
  end subroutine cubetuple_close
  !
  subroutine cubetuple_free(tuple,error)
    !---------------------------------------------------------------------
    ! Free the memory-consuming components of a 'cubetuple_t' instance.
    ! The cubetuple_t remains useable after this free. It is the
    ! responsibility of the caller to ensure the data remains available
    ! elsewhere (most likely on disk).
    ! Use cubetuple_final to free consistently all the object.
    !---------------------------------------------------------------------
    class(cubetuple_t), intent(inout) :: tuple
    logical,            intent(inout) :: error
    ! Local
    integer(kind=4) :: iaccess
    !
    do iaccess=1,cubetuple_naccess
      call tuple%cube(iaccess)%free(error)
      if (error)  return
    enddo
    nullify(tuple%current)
  end subroutine cubetuple_free
  !
  subroutine cube_free(cub,error)
    use cubedag_tuple
    !---------------------------------------------------------------------
    ! Free the memory-consuming components of a 'cube_t' instance. The
    ! cube_t remains useable after this free. It is the responsibility of
    ! the caller to ensure the data remains available elsewhere (most
    ! likely on disk).
    ! Use cube_final to free consistently all the object.
    !---------------------------------------------------------------------
    class(cube_t), intent(inout) :: cub
    logical,       intent(inout) :: error
    !
    call cub%tuple%free(error)
    if (error)  return
    call cubedag_tuple_rmmemo(cub%node%tuple,error)
    if (error)  return
  end subroutine cube_free
  !
  subroutine cubetuple_final(tuple)
    !---------------------------------------------------------------------
    ! Finalize a 'cubetuple_t' instance, i.e. free all its components
    ! before deleting the object itself
    !---------------------------------------------------------------------
    type(cubetuple_t), intent(inout) :: tuple
    ! Local
    integer(kind=4) :: iaccess
    !
    do iaccess=1,cubetuple_naccess
      call cubeio_cube_final(tuple%cube(iaccess))
    enddo
    nullify(tuple%current)
  end subroutine cubetuple_final
  !
  subroutine cube_final(cub)
    !---------------------------------------------------------------------
    ! Finalize a 'cube_t' instance, i.e. free all its components before
    ! deleting the object itself
    !---------------------------------------------------------------------
    type(cube_t), intent(inout) :: cub
    !
    logical :: error
    !
    error = .false.
    call cubetools_header_final(cub%head,error)
    if (error)  continue
    ! call cubetuple_final(cub%tuple) => implicit at finalization time
  end subroutine cube_final
  !
  function cubetuple_cube_ptr(dno,error)
    !-------------------------------------------------------------------
    ! Check if the input class is strictly a 'cube_t', and return a
    ! pointer to it if relevant.
    !-------------------------------------------------------------------
    type(cube_t), pointer :: cubetuple_cube_ptr  ! Function value on return
    class(cubedag_node_object_t), pointer       :: dno
    logical,                      intent(inout) :: error
    !
    character(len=*), parameter :: rname='CUBE>PTR'
    !
    select type(dno)
    type is (cube_t)
      cubetuple_cube_ptr => dno
    class default
      cubetuple_cube_ptr => null()
      call cubetuple_message(seve%e,rname,'Internal error: object is not a cube_t')
      error = .true.
      return
    end select
  end function cubetuple_cube_ptr
end module cube_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
