!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_imareal
  use cube_types
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubemain_sperange_types
  use cubetemplate_messaging
  !
  public :: imareal
  public :: cubetemplate_imareal_command
  private
  !
  type :: imareal_comm_t
     type(option_t), pointer :: comm  
     type(option_t), pointer :: factor
     type(sperange_opt_t)    :: range
   contains
     procedure, public  :: register => cubetemplate_imareal_register
     procedure, private :: parse    => cubetemplate_imareal_parse
     procedure, private :: main     => cubetemplate_imareal_main
  end type imareal_comm_t
  type(imareal_comm_t) :: imareal
  !
  integer(kind=4), parameter :: icube = 1
  type imareal_user_t
     type(cubeid_user_t)   :: cubeids
     type(sperange_user_t) :: range
     character(len=argu_l) :: factor
   contains
     procedure, private :: toprog => cubetemplate_imareal_user_toprog
  end type imareal_user_t
  type imareal_prog_t
     type(sperange_prog_t) :: range
     real(kind=sign_k)     :: factor
     type(cube_t), pointer :: incube
     type(cube_t), pointer :: oucube
   contains
     procedure, private :: header => cubetemplate_imareal_prog_header
     procedure, private :: data   => cubetemplate_imareal_prog_data
     procedure, private :: loop   => cubetemplate_imareal_prog_loop
     procedure, private :: act    => cubetemplate_imareal_prog_act
  end type imareal_prog_t
  !
contains
  !
  subroutine cubetemplate_imareal_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(imareal_user_t) :: user
    character(len=*), parameter :: rname='IMAREAL>COMMAND'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call imareal%parse(line,user,error)
    if (error) return
    call imareal%main(user,error)
    if (error) continue
  end subroutine cubetemplate_imareal_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_imareal_register(imareal,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(imareal_comm_t), intent(inout) :: imareal
    logical,               intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    type(standard_arg_t) :: stdarg
    character(len=*), parameter :: comm_abstract = 'Template command for working image wise'
    character(len=*), parameter :: comm_help = &
         'Input and output cube ares real'
    character(len=*), parameter :: rname='IMAREAL>REGISTER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'IMAREAL','[cube]',&
         comm_abstract,&
         comm_help,&
         cubetemplate_imareal_command,&
         imareal%comm,error)
    if (error) return
    call cubearg%register(&
         'CUBE',&
         'Signal cube',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         error)
    if (error) return
    !
    call imareal%range%register(&
         'RANGE',&
         'Define velocity range(s)',&
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'FACTOR','factor',&
         'Multiply data by a factor',&
         strg_id,&
         imareal%factor,error)
    if (error) return
    call stdarg%register(&
         'factor',&
         'factor',&
         'default is 1',&
         code_arg_mandatory, error)
    if (error) return
  end subroutine cubetemplate_imareal_register
  !
  subroutine cubetemplate_imareal_parse(imareal,line,user,error)
    !----------------------------------------------------------------------
    ! IMAREAL cubname
    ! /RANGE vfirst vlast
    ! /FACTOR factor
    !----------------------------------------------------------------------
    class(imareal_comm_t), intent(in)    :: imareal
    character(len=*),      intent(in)    :: line
    type(imareal_user_t),  intent(out)   :: user
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='IMAREAL>PARSE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,imareal%comm,user%cubeids,error)
    if (error) return
    call imareal%range%parse(line,user%range,error)
    if (error) return
    call cubetemplate_imareal_parse_factor(line,imareal%factor,user%factor,error)
    if (error) return
  end subroutine cubetemplate_imareal_parse
  !
  subroutine cubetemplate_imareal_parse_factor(line,opt,user,error)
    !----------------------------------------------------------------------
    ! /FACTOR factor
    !----------------------------------------------------------------------
    character(len=*),       intent(in)    :: line
    type(option_t),         intent(in)    :: opt
    character(len=*),       intent(out)   :: user
    logical,                intent(inout) :: error
    !
    logical :: present
    integer(kind=4), parameter :: iarg=1
    character(len=*), parameter :: rname='IMAREAL>PARSE>FACTOR'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call opt%present(line,present,error)
    if (error) return
    if (present) then
       call cubetools_getarg(line,opt,iarg,user,mandatory,error)
       if (error) return
    else
       user = strg_star
    endif
  end subroutine cubetemplate_imareal_parse_factor
  !
  subroutine cubetemplate_imareal_main(imareal,user,error)    
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(imareal_comm_t), intent(in)    :: imareal
    type(imareal_user_t),  intent(inout) :: user
    logical,               intent(inout) :: error
    !
    type(imareal_prog_t) :: prog
    character(len=*), parameter :: rname='IMAREAL>MAIN'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call user%toprog(imareal,prog,error)
    if (error) return
    call prog%header(error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubetemplate_imareal_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_imareal_user_toprog(user,comm,prog,error)
    use cubetools_user2prog
    use cubetools_unit
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(imareal_user_t), intent(in)    :: user
    type(imareal_comm_t),  intent(in)    :: comm
    type(imareal_prog_t),  intent(out)   :: prog
    logical,               intent(inout) :: error
    !
    type(unit_user_t) :: nounit
    real(kind=sign_k), parameter :: default=1.0
    character(len=*), parameter :: rname='IMAREAL>USER>TOPROG'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(comm%comm,icube,user%cubeids,&
         code_access_imaset,code_read,prog%incube,error)
    if (error) return
    !
    call user%range%toprog(prog%incube,prog%range,error)
    if (error) return
    !
    call cubetools_unit_get(strg_star,code_unit_unk,nounit,error)
    if (error) return
    call cubetools_user2prog_resolve_star(user%factor,nounit,default,prog%factor,error)
    if (error) return
  end subroutine cubetemplate_imareal_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_imareal_prog_header(prog,error)
    use cubedag_allflags
    use cubeadm_clone
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(imareal_prog_t), intent(inout) :: prog
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='IMAREAL>PROG>HEADER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(prog%incube,flag_template,prog%oucube,error)
    if (error) return
  end subroutine cubetemplate_imareal_prog_header
  !
  subroutine cubetemplate_imareal_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(imareal_prog_t), intent(inout) :: prog
    logical,               intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='IMAREAL>PROG>DATA'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error)  exit
       !$OMP TASK SHARED(prog) FIRSTPRIVATE(iter,error)
       if (.not.error)  &
         call prog%loop(iter%first,iter%last,error)
       !$OMP END TASK
    enddo ! ie
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubetemplate_imareal_prog_data
  !   
  subroutine cubetemplate_imareal_prog_loop(prog,first,last,error)
    use cubeadm_entryloop
    use cubemain_image_real
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(imareal_prog_t), intent(inout) :: prog
    integer(kind=entr_k),  intent(in)    :: first
    integer(kind=entr_k),  intent(in)    :: last
    logical,               intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    type(image_t) :: inima,ouima
    character(len=*), parameter :: rname='IMAREAL>PROG>LOOP'
    !
    call inima%init(prog%incube,error)
    if (error) return
    call ouima%reallocate('ouima',prog%oucube%head%arr%n%l,prog%oucube%head%arr%n%m,error)
    if (error) return
    !
    do ie=first,last
      call cubeadm_entryloop_iterate(ie,error)
      if (error)  return
      call prog%act(ie,inima,ouima,error)
      if (error)  return
    enddo
  end subroutine cubetemplate_imareal_prog_loop
  !   
  subroutine cubetemplate_imareal_prog_act(prog,ie,inima,ouima,error)
    use cubemain_image_real
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(imareal_prog_t), intent(inout) :: prog
    integer(kind=entr_k),  intent(in)    :: ie
    type(image_t),         intent(inout) :: inima
    type(image_t),         intent(inout) :: ouima
    logical,               intent(inout) :: error
    !
    integer(kind=pixe_k) :: il,im
    character(len=*), parameter :: rname='IMAREAL>PROG>ACT'
    !
    call inima%get(prog%incube,ie,error)
    if (error)  return
    do im=1,prog%incube%head%arr%n%m
       do il=1,prog%incube%head%arr%n%l
          ouima%z(il,im) = prog%factor*inima%z(il,im)
       enddo ! im
    enddo ! il
    call ouima%put(prog%oucube,ie,error)
    if (error)  return
  end subroutine cubetemplate_imareal_prog_act
end module cubetemplate_imareal
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
