!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_average
  use cubetools_structure
  use cube_types
  use cubemain_messaging
  use cubemain_lists
  !
  public :: cubemain_average_command,cubemain_average_register
  private
  !
  type :: average_comm_t
     type(option_t), pointer :: average  
     type(option_t), pointer :: weight   
  end type average_comm_t
  type(average_comm_t) :: comm
  !
  type average_user_t
     type(cublist_t)       :: inlist   ! Input list containing the names of the cubes to be averaged
     logical               :: donoise  ! Weighting by noise
  end type average_user_t
  type average_prog_t
     type(cublist_t)       :: inlist   ! Input list containing the cubes to be averaged
     type(cube_t), pointer :: average  ! Output averaged cube
     type(cube_t), pointer :: weight   ! Weight for each element of the average cube
     logical               :: dospa    ! Average to be done spatially or spectrally
  end type average_prog_t
  !
contains
  !
  subroutine cubemain_average_register(error)
    use cubetools_structure
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    character(len=*), parameter :: comm_abstract = 'Average cubes with the same spatial grid'
    character(len=*), parameter :: comm_help = &
         strg_id
    character(len=*), parameter :: rname='AVERAGE>REGISTER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    ! call cubetools_register_command(&
    !      'AVERAGE',&
    !      comm_abstract,&
    !      comm_help,&
    !      cubemain_average_command,&
    !      error)
    ! if (error) return
    ! call cubemain_cublist_register(&
    !      'AVERAGE',&
    !      comm_abstract,&
    !      comm_help,&
    !      comm%average,error)
    ! if (error) return
    !
    call cubemain_cublist_register_weights(&
         'WEIGHT',&
         'Define the weighting scheme for the averaging',&
         comm%weight,error)
    if (error) return
  end subroutine cubemain_average_register
  !
  subroutine cubemain_average_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(average_user_t) :: user
    type(average_prog_t) :: prog
    character(len=*), parameter :: rname='AVERAGE>COMMAND'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    call cubemain_average_parse(line,user,error)
    if (error) return
    call cubemain_average_main(user,prog,error)
    if (error) continue
  end subroutine cubemain_average_command
  !
  subroutine cubemain_average_parse(line,user,error)
    !----------------------------------------------------------------------
    ! AVERAGE cub1 cub2 ... cubn
    ! [/WEIGHT noise|equal|w1...wn]
    !----------------------------------------------------------------------
    character(len=*),     intent(in)    :: line
    type(average_user_t), intent(out)   :: user
    logical,              intent(inout) :: error
    !
    integer(kind=4), parameter :: iweig = 1
    !
    character(len=*), parameter :: rname='AVERAGE>PARSE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubemain_cublist_parse(line,comm%average,user%inlist,error)
    if(error) return
    call cubemain_cublist_parse_weights(line,comm%weight,user%inlist,user%donoise,error)
    if (error) return
    !
    call cubemain_average_feedback(user)
  end subroutine cubemain_average_parse
  !
  subroutine cubemain_average_feedback(user)
    !----------------------------------------------------------------------
    ! Gives the user feedback on the inputs
    !----------------------------------------------------------------------
    type(average_user_t), intent(in)   :: user
    !
    character(len=*), parameter :: rname='AVERAGE>FEEDBACK'
    !
    integer(kind=4) :: icub
    character(len=mess_l) :: mess
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')    
    !
    call cubemain_message(seve%r,rname,'')
    write(mess,*) 'Input cubes and their weights: '
    call cubemain_message(seve%r,rname,mess)
    call cubemain_message(seve%r,rname,'')
    do icub=1,user%inlist%n
       if (user%donoise) then
          write(mess,*) 'w=Noise; '//trim(user%inlist%entries(icub)%name)
       else
          write(mess,'(a,f5.1,a)') 'w=',user%inlist%entries(icub)%weig,'; '//trim(user%inlist%entries(icub)%name)
       endif
       call cubemain_message(seve%r,rname,mess)
    enddo
    call cubemain_message(seve%r,rname,'')
  end subroutine cubemain_average_feedback
  !
  subroutine cubemain_average_main(user,prog,error)
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(average_user_t), intent(in)    :: user
    type(average_prog_t), intent(inout) :: prog
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='AVERAGE>MAIN'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubemain_average_header(user,prog,error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call cubemain_average_data(prog,error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubemain_average_main
  !
  subroutine cubemain_average_header(user,prog,error)
    use cubetools_header_types
    use cubedag_allflags
    use cubeadm_clone
    use cubemain_stitch
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(average_user_t), intent(in)    :: user
    type(average_prog_t), intent(inout) :: prog
    logical,              intent(inout) :: error
    !
    integer(kind=code_k) :: ouaccess
    character(len=*), parameter :: rname='AVERAGE>HEADER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubemain_cublist_copy(user%inlist,prog%inlist,error)
    if(error) return
    call cubemain_cublist_get_headers(code_access_imaset_or_speset,prog%inlist,error)
    if(error) return
    !
    call cubemain_average_consistency(prog,error)
    if (error) return
    !
    if (prog%inlist%access.eq.code_cube_imaset) then
       ouaccess = code_cube_imaset
       prog%dospa = .true.
    else if (prog%inlist%access.eq.code_cube_speset) then
       ouaccess = code_cube_speset
       prog%dospa = .false.
    else
       call cubemain_message(seve%e,rname,'Unknown access for entry list')
       error = .true.
       return
    endif
    !
    call cubeadm_clone_header(prog%inlist%entries(1)%cube,[flag_average,flag_cube],&
         prog%average,error,access=ouaccess)
    if (error) return
    call cubemain_stitch_observatory(prog%inlist,prog%average,error)
    if (error) return
    call cubeadm_clone_header(prog%inlist%entries(1)%cube,[flag_average,flag_weight],&
         prog%weight,error,access=ouaccess)
    if (error) return
    call cubetools_header_copy(prog%average%head,prog%weight%head,error)
    if (error) return
    !
  end subroutine cubemain_average_header
  !
  subroutine cubemain_average_consistency(prog,error)
    use cubetools_consistency_methods
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(average_prog_t), intent(inout) :: prog
    logical,              intent(inout) :: error
    !
    integer(kind=4) :: icub
    logical :: prob
    character(len=*), parameter :: rname='AVERAGE>CONSISTENCY'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    prob = .false.
    do icub=2,prog%inlist%n
       call cubetools_consistency_grid(prog%inlist%entries(1)%name,prog%inlist%entries(1)%cube%head,&
            prog%inlist%entries(icub)%name,prog%inlist%entries(icub)%cube%head,prob,error)
       if (error) return
    end do
    if (cubetools_consistency_failed(rname,prob,error)) return
  end subroutine cubemain_average_consistency
  !
  subroutine cubemain_average_data(prog,error)
    use cubemain_stitch_spatial
    use cubemain_stitch_spectral
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    type(average_prog_t), intent(inout) :: prog
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='AVERAGE>DATA'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (prog%dospa) then
       call cubemain_stitch_spatial_merge(prog%inlist,prog%average,prog%weight,error)
       if(error) return
    else
       call cubemain_stitch_spectral_merge(prog%inlist,prog%average,prog%weight,error)
       if(error) return
    endif
  end subroutine cubemain_average_data
end module cubemain_average
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
