!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_detect
  use cube_types
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubemain_sperange_types
  use cubemain_messaging
  !
  public :: detect
  public :: cubemain_detect_command
  private
  !
  type :: detect_comm_t
     type(option_t), pointer :: comm  
     type(option_t), pointer :: islands
   contains
     procedure, public  :: register => cubemain_detect_register
     procedure, private :: parse    => cubemain_detect_parse
     procedure, private :: main     => cubemain_detect_main
  end type detect_comm_t
  type(detect_comm_t) :: detect
  !
  integer(kind=4), parameter :: icube = 1
  integer(kind=4), parameter :: ilabeled = 2
  type detect_user_t
     type(cubeid_user_t)   :: cubeids
     character(len=argu_l) :: range(2)
   contains
     procedure, private :: toprog => cubemain_detect_user_toprog
  end type detect_user_t
  type detect_prog_t
     integer(kind=data_k)  :: range(2)
     type(cube_t), pointer :: cube
     type(cube_t), pointer :: labeled
     type(cube_t), pointer :: detected
     type(cube_t), pointer :: residuals
   contains
     procedure, private :: header => cubemain_detect_prog_header
     procedure, private :: data   => cubemain_detect_prog_data
     procedure, private :: loop   => cubemain_detect_prog_loop
     procedure, private :: act    => cubemain_detect_prog_act
  end type detect_prog_t
  !
contains
  !
  subroutine cubemain_detect_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(detect_user_t) :: user
    character(len=*), parameter :: rname='DETECT>COMMAND'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call detect%parse(line,user,error)
    if (error) return
    call detect%main(user,error)
    if (error) continue
  end subroutine cubemain_detect_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubemain_detect_register(detect,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(detect_comm_t), intent(inout) :: detect
    logical,              intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    type(standard_arg_t) :: stdarg
    character(len=*), parameter :: comm_abstract='Split a cube into detected signal, and residuals'
    character(len=*), parameter :: comm_help = &
         'Select from a segmented SNR cube a segment range and create a &
         &cube of detected signal inside the corresponding island mask. &
         &The remainder is output into a residual cube.'
    character(len=*), parameter :: rname='DETECT>REGISTER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'DETECT','[cube]',&
         comm_abstract,&
         comm_help,&
         cubemain_detect_command,&
         detect%comm,error)
    if (error) return
    call cubearg%register(&
         'SIGNAL',&
         'Signal cube',&
         strg_id,&
         code_arg_optional,&
         [flag_cube],&
         error)
    if (error) return
    call cubearg%register(&
         'SEGMENTED',&
         'Segmented SNR cube',&
         strg_id,&
         code_arg_optional,&
         [flag_segments],&
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'SEGMENTS','first last',&
         'First and last segments to form the detection mask',&
         strg_id,&
         detect%islands,error)
    if (error) return
    call stdarg%register(&
         'first',&
         'first',&
         'Default to 1',&
         code_arg_mandatory, error)
    if (error) return
    call stdarg%register(&
         'last',&
         'last',&
         'Default to the total number of segments minus 1',&
         code_arg_mandatory, error)
    if (error) return
  end subroutine cubemain_detect_register
  !
  subroutine cubemain_detect_parse(detect,line,user,error)
    !----------------------------------------------------------------------
    ! DETECT cubeid /ISLANDS first last
    !----------------------------------------------------------------------
    class(detect_comm_t), intent(in)    :: detect
    character(len=*),     intent(in)    :: line
    type(detect_user_t),  intent(out)   :: user
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='DETECT>PARSE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,detect%comm,user%cubeids,error)
    if (error) return
    call cubemain_detect_parse_twoarg(line,detect%islands,user%range,error)
    if (error) return
  end subroutine cubemain_detect_parse
  !
  subroutine cubemain_detect_parse_twoarg(line,opt,args,error)
    !----------------------------------------------------------------------
    ! /OPT first last
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    type(option_t),   intent(in)    :: opt
    character(len=*), intent(out)   :: args(2)
    logical,          intent(inout) :: error
    !
    logical :: present
    integer(kind=4) :: iarg
    character(len=*), parameter :: rname='DETECT>PARSE>TWOARG'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call opt%present(line,present,error)
    if (error) return
    if (present) then
       do iarg=1,2
          call cubetools_getarg(line,opt,iarg,args(iarg),mandatory,error)
          if (error) return
       enddo ! iarg
    else
       do iarg=1,2
          args(iarg) = strg_star
       enddo ! iarg
    endif
  end subroutine cubemain_detect_parse_twoarg
  !
  subroutine cubemain_detect_main(detect,user,error)    
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(detect_comm_t), intent(in)    :: detect
    type(detect_user_t),  intent(inout) :: user
    logical,              intent(inout) :: error
    !
    type(detect_prog_t) :: prog
    character(len=*), parameter :: rname='DETECT>MAIN'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call user%toprog(prog,error)
    if (error) return
    call prog%header(error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubemain_detect_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubemain_detect_user_toprog(user,prog,error)
    use cubetools_arrelt_types
    use cubetools_header_methods    
    use cubetools_user2prog
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(detect_user_t), intent(in)    :: user
    type(detect_prog_t),  intent(out)   :: prog
    logical,              intent(inout) :: error
    !
    integer(kind=4) :: iarg
    type(arrelt_t) :: min,max
    integer(kind=data_k) :: default(2)
    character(len=*), parameter :: rname='DETECT>USER>TOPROG'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(detect%comm,icube,user%cubeids,&
         code_access_subset,code_read,prog%cube,error)
    if (error) return
    call cubeadm_cubeid_get_header(detect%comm,ilabeled,user%cubeids,&
         code_access_subset,code_read,prog%labeled,error)
    if (error) return
    !
    call cubetools_header_get_array_minmax(prog%labeled%head,min,max,error)
    if (error) return
    default(1) = 1
    default(2) = max%val-1
    do iarg=1,2
       call cubetools_user2prog_resolve_star(user%range(iarg),default(iarg),default(iarg),error)
       if (error) return
    enddo ! iarg
    prog%range(1) = max%val-default(2)+1
    prog%range(2) = max%val-default(1)+1
  end subroutine cubemain_detect_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubemain_detect_prog_header(prog,error)
    use cubedag_allflags
    use cubeadm_clone
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(detect_prog_t), intent(inout) :: prog
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='DETECT>PROG>HEADER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(prog%cube,flag_detected,prog%detected,error)
    if (error) return
    call cubeadm_clone_header(prog%cube,flag_residuals,prog%residuals,error)
    if (error) return
  end subroutine cubemain_detect_prog_header
  !
  subroutine cubemain_detect_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(detect_prog_t), intent(inout) :: prog
    logical,              intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iterentry
    character(len=*), parameter :: rname='DETECT>PROG>DATA'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iterentry,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iterentry)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iterentry,error))
       if (error)  exit
       !$OMP TASK SHARED(prog) FIRSTPRIVATE(iterentry,error)
       if (.not.error)  &
         call prog%loop(iterentry,error)
       !$OMP END TASK
    enddo ! ie
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubemain_detect_prog_data
  !   
  subroutine cubemain_detect_prog_loop(prog,iterentry,error)
    use cubeadm_entryloop
    use cubeadm_taskloop
    use cubemain_subcube_real
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(detect_prog_t),     intent(inout) :: prog
    type(cubeadm_iterator_t), intent(in)    :: iterentry
    logical,                  intent(inout) :: error
    !
    type(subcube_iterator_t) :: itersubcube
    integer(kind=entr_k) :: isubcube
    character(len=*), parameter :: rname='DETECT>PROG>LOOP'
    !
    do isubcube=iterentry%first,iterentry%last
      call cubeadm_entryloop_iterate(isubcube,error)
      if (error) return
      call itersubcube%init(iterentry,isubcube,error)
      if (error) return
      call prog%act(itersubcube,error)
      if (error) return
    enddo
  end subroutine cubemain_detect_prog_loop
  !   
  subroutine cubemain_detect_prog_act(prog,iter,error)
    use cubetools_nan
    use cubemain_subcube_real
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(detect_prog_t),     intent(inout) :: prog
    type(subcube_iterator_t), intent(in)    :: iter
    logical,                  intent(inout) :: error
    !
    integer(kind=data_k) :: ix,nx
    integer(kind=data_k) :: iy,ny
    integer(kind=data_k) :: iz,nz
    type(subcube_t) :: cube,labeled,detected,residuals
    character(len=*), parameter :: rname='DETECT>PROG>ACT'
    !
    call cube%init(prog%cube,error)
    if (error)  return
    call labeled%init(prog%labeled,error)
    if (error)  return
    call detected%reallocate(prog%detected,iter,error)
    if (error)  return
    call residuals%reallocate(prog%residuals,iter,error)
    if (error)  return
    !
!    print *,prog%range
    !
    call cube%get(prog%cube,iter,error)
    if (error)  return
    call labeled%get(prog%labeled,iter,error)
    if (error)  return
    !
    nx = cube%n1
    ny = cube%n2
    nz = cube%n3
    do iz=1,nz
       do iy=1,ny
          do ix=1,nx
             if (ieee_is_nan(cube%data(ix,iy,iz))) then
                detected%data(ix,iy,iz)  = gr4nan
                residuals%data(ix,iy,iz) = gr4nan
             else
                if ((prog%range(1).le.labeled%data(ix,iy,iz)).and.&
                    (labeled%data(ix,iy,iz).le.prog%range(2))) then
                   detected%data(ix,iy,iz)  = cube%data(ix,iy,iz)
                   residuals%data(ix,iy,iz) = 0
                else
                   detected%data(ix,iy,iz)  = 0
                   residuals%data(ix,iy,iz) = cube%data(ix,iy,iz)
                endif
             endif
          enddo ! ix
       enddo ! iy
    enddo ! iz
    call detected%put(prog%detected,iter,error)
    if (error)  return
    call residuals%put(prog%residuals,iter,error)
    if (error)  return
  end subroutine cubemain_detect_prog_act
end module cubemain_detect
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
