subroutine cubeio_cube_init(cub,error)
  use gkernel_interfaces
  use cubeio_interfaces, except_this=>cubeio_cube_init
  use cubeio_types
  use cubeio_timing
  !---------------------------------------------------------------------
  ! @ public
  ! Initialize a cubeio_cube_t
  !---------------------------------------------------------------------
  type(cubeio_cube_t), intent(inout) :: cub
  logical,             intent(inout) :: error
  !
  ! Initialize the HGDF header. Must be done once and only once, before
  ! first use of the header. Must come before cubeio_free_cubeio_cube so
  ! that it works properly. Use same test as GIO does internally:
  if (cub%hgdf%header.ne.1)  call gildas_null(cub%hgdf)
  !
  ! Unclear if all access timings should be initialized here.
  call cubeio_timing_init(cub%time,error)
  if (error)  return
  !
  ! Initialize the buffer block. 'free' subroutine does this correctly.
  call cubeio_block_free(cub%block,error)
  if (error)  return
  !
end subroutine cubeio_cube_init
