subroutine cubeio_dump_cube(cubset,cubdef,head,cub,error)
  use cubeio_messaging
  use cubeio_interfaces, except_this=>cubeio_dump_cube
  use cubeio_types
  !---------------------------------------------------------------------
  ! @ public
  ! Dump (i.e. write or update) a cube from memory to disk, if relevant
  ! (i.e. nothing done for a read-only cube).
  !---------------------------------------------------------------------
  type(cube_setup_t),  intent(in)    :: cubset
  type(cube_define_t), intent(in)    :: cubdef
  type(cube_header_t), intent(in)    :: head
  type(cubeio_cube_t), intent(inout) :: cub
  logical,             intent(inout) :: error
  ! Local
  character(len=*), parameter :: rname='DUMP>CUBE'
  !
  call cubeio_set_descriptor_external(cubset,cubdef,.false.,cub,error)
  if (error)  return
  !
  select case (cub%desc%action)
  case (code_read_head,code_read)
    ! Nothing to be done
  case (code_write)
    call cubeio_write_cube(cubset,cubdef,head,cub,error)
  case (code_update)
    call cubeio_update_cube(cubset,cubdef,head,cub,error)
  case default
    call cubeio_message(seve%e,rname,'Invalid action code')
    error = .true.
  end select
  !
end subroutine cubeio_dump_cube
