!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubedag_library
  use cubedag_parameters
  use cubedag_allflags
  use cubedag_messaging
  use cubedag_node
  use cubedag_dag
  use cubedag_history
  use cubedag_hrepository
  !
  public :: cubedag_init,cubedag_exit
  private
  !
contains
  !
  subroutine cubedag_init(error)
    use cubedag_repository
    use cubedag_type
    !----------------------------------------------------------------------
    ! Initialization
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    ! Local
    character(len=*), parameter :: rname='INIT'
    !
    ! Declare support for the basic Fortran type supported by the DAG
    call cubedag_type_register(&
         'NODE','node',&
         cubedag_node_allocate,  &
         cubedag_node_deallocate,  &
         code_type_node,error)
    if (error)  return
    !
    ! Must come after
    call cubedag_repository_init('zzz',error)
    if (error)  return
    call cubedag_hrepository_init('zzz',error)
    if (error)  return
    !
    call cubedag_flag_init(error)
    if (error)  return
    call cubedag_allflags_init(error)
    if (error) return
  end subroutine cubedag_init
  !
  subroutine cubedag_exit(error)
    !----------------------------------------------------------------------
    ! Cleaning on exit
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    ! Local
    character(len=*), parameter :: rname='EXIT'
    !
    call cubedag_dag_destroy(error)
    if (error)  continue
    call cubedag_history_final(error)
    if (error)  continue
  end subroutine cubedag_exit
end module cubedag_library
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
