!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeadm_free
  use cubeadm_messaging
  use cubetools_structure
  !
  public :: cubeadm_free_register,cubeadm_free_command
  private
  !
  type :: free_comm_t
     type(option_t), pointer :: free  
  end type free_comm_t
  type(free_comm_t) :: comm
  !
contains
  !
  subroutine cubeadm_free_register(error)
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    logical,          intent(inout) :: error
    !
    character(len=*), parameter :: comm_abstract = &
         'Free the current DAG'
    character(len=*), parameter :: comm_help = &
         'Free the DAG, i.e. delete all the cube and history&
         & structures. Beware memory-only objects are lost during&
         & this operation (use command SNAPSHOT to save them for&
         & possible later reuse). In return the DAG is ready for use&
         & as if starting from scratch.'
    character(len=*), parameter :: rname='FREE>REGISTER'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'FREE','',&
         comm_abstract,&
         comm_help,&
         cubeadm_free_command,&
         comm%free,error)
    if (error) return
  end subroutine cubeadm_free_register
  !
  subroutine cubeadm_free_command(line,error)
    use cubedag_library
    use cubedag_repository
    use cubedag_hrepository
    !---------------------------------------------------------------------
    ! Support for command
    !  ADM\FREE
    !---------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    call cubedag_exit(error)
    if (error)  return
    !
    call cubedag_repository_init('zzz',error)
    if (error)  return
    call cubedag_hrepository_init('zzz',error)
    if (error)  return
    !
  end subroutine cubeadm_free_command
  !
end module cubeadm_free
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
