#ifndef _SIGPARAMS_H_
#define _SIGPARAMS_H_

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef HAVE_PRINTF_H
#include <printf.h>
#endif

/* sigparams.c */
void init_sigparams(void);

void foreach_sigparams(void);

int print_count_arginfo(const struct printf_info *info, 
			size_t n, 
			int *argtypes);

int print_count(FILE *stream, 
		const struct printf_info *info, 
		const void *const *args);


int print_delta_arginfo(const struct printf_info *info, 
			size_t n, 
			int *argtypes);

int print_delta(FILE *stream, 
		const struct printf_info *info, 
		const void *const *args);


int print_time_arginfo(const struct printf_info *info, 
		       size_t n, 
		       int *argtypes);

int print_time(FILE *stream, 
	       const struct printf_info *info, 
	       const void *const *args);

int print_daycount_arginfo(const struct printf_info *info, 
			   size_t n, 
			   int *argtypes);

int print_daycount(FILE *stream, 
		   const struct printf_info *info, 
		   const void *const *args);

int print_first_in_day_arginfo(const struct printf_info *info, 
			       size_t n, 
			       int *argtypes);

int print_first_in_day(FILE *stream, 
		       const struct printf_info *info, 
		       const void *const *args);

int print_arginfo(const struct printf_info *info, 
		  size_t n, 
		  int *argtypes);

#endif
