
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_LIBGEN_H
#include <libgen.h>
#endif
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "version.h"
#include "gensig.h"
#include "tagdb.h"
#include "sigformat.h"
#include "sigfifo.h"

int setup_fifo(char *fifo_name)
{
   int rv;
   char *saved_fifoname;
   char *directory;
   char buf[BUFSIZ];
   struct stat statbuf;

   saved_fifoname = (char*)malloc(strlen(fifo_name) + 1);
   if (!saved_fifoname)
   {
      perror("setup_fifo: malloc saved_fifoname");
   }

   /* some systems modify the string sent to dirname() */
   /* others return pointer to static memory */
   /* this should work either way... */
   directory = dirname(strcpy(saved_fifoname, fifo_name));

   if (!strcmp(directory, fifo_name))
   {
      fprintf(stderr, "Broken dirname()!\nI'll just assume the directory's there...\n");
   }
   else
   {
      if (strcmp(directory, "."))
      {
         if ((rv = stat(directory, &statbuf)))
         {
            perror((const char*)sprintf(buf, "setup_fifo: %s", directory));
            return -1;
         }
      }
   }

   free(saved_fifoname);

   /* done with directory check... */

   rv = stat(fifo_name, &statbuf);

   if ( (rv == 0) && (S_ISFIFO(statbuf.st_mode)) )
   {
      /* everything's already set up! */
   }
   else
   {
      if ( (rv == -1) && (errno == ENOENT) )
      {
         /* still need to make the fifo, but otherwise we're OK */
      }
      else if (S_ISREG(statbuf.st_mode))
      {
         if ((rv = unlink(fifo_name)))
         {
            perror("setup_fifo: unlink");
            return -1;
         }
      }
      else
      {
         fprintf(stderr, "setup_fifo: %s is not a regular file or a fifo: aborting\n", fifo_name);
         return -1;
      }

      if ((rv = mkfifo(fifo_name, 0644)))
      {
         perror("setup_fifo: mkfifo");
         return -1;
      }
   }

   return rv;
}

int reset_fifo(char *fifo_name, int leavefile)
{
   int rv, fd;
   char *tagline;
   char *dname;
   struct stat statbuf;
   char signature[BUFSIZ];

   /* make sure the directory's there... */

   dname = (char*)malloc(strlen(fifo_name) + 1);
   if (!dname)
   {
      perror("reset_fifo: malloc");
   }
   dirname(strcpy(dname, fifo_name));

   if (strcmp(dname, "."))
   {
      if ((rv = stat(dname, &statbuf)))
      {
         perror("reset_fifo: dir check");
         return -1;
      }
   }

   free(dname);

   /* look where the FIFO should be */

   rv = stat(fifo_name, &statbuf);

   if ( (rv == 0) && (S_ISFIFO(statbuf.st_mode)) )
   {
      /* fifo's there, we delete it */
      if ((rv = unlink(fifo_name)))
      {
         perror("reset_fifo: unlink");
         return -1;
      }
   }
   else if ( (rv == 0) && (! S_ISREG(statbuf.st_mode)) )
   {
      perror("reset_fifo: stat");
      return -1;
   }

   /* (maybe) create flat file in its place */

   if (leavefile)
   {

      if ( (fd = open(fifo_name, O_WRONLY|O_CREAT|O_TRUNC, 0644)) < 0 )
      {
         perror("reset_fifo: open");
         return -1;
      }

      /* write a sig & tagline to the file */

      tagline = get_random_tagline(1);

      sprintf(signature, get_sigformat(), tagline?tagline:"");

      write(fd, signature, strlen(signature));
      close(fd);

   }

   return rv;
}


