
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#else
extern int optind;
extern char *optarg;
extern int getopt (int argc, char *const *argv, const char *shortopts);
#endif

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include "version.h"
#include "gensig.h"
#include "sigfifo.h"
#include "tagdb.h"

int debug = 0;
int default_tagfiles_also = 0;

void showsyntax()
{
#ifdef HAVE_GETOPT_LONG
   printf("%s\n\
This is cattag, part of the gensig system.\n\
Usage: cattag [-h] [-v] [--help] [--version] [tagfile [tagfile [...]]]\n\
  -a, --add             Add specified tagfiles to search list\n\
                        (default is to *only* use files specified)\n\
  -d, --debug		Debug: be verbose\n\
  -h, --help		Print this message\n\
  -v, --version		Print version information\n\
", version);
#else
   printf("%s\n\
This is cattag, part of the gensig system.\n\
Usage: cattag [-h] [-v] [tagfile [tagfile [...]]]\n\
  -a    Add specified tagfiles to search list\n\
        (default is to *only* use files specified)\n\
  -d	debug: be verbose\n\
  -h	help: Print this message\n\
  -v	version: Print version information\n\
", version);
#endif
}

int main(int argc, char **argv)
{
   int tf_count = 0;
   int opt_char;
   char getopt_optstring[] = "adhv";
#ifdef HAVE_GETOPT_LONG
   int opt_index = 0;
   static struct option long_options[] = {
		/* name, hasarg, flag, val */
		{ "add", no_argument, NULL, 'a' },
		{ "debug", no_argument, NULL, 'd' },
		{ "help", no_argument, NULL, 'h' },
		{ "version", no_argument, NULL, 'v' },
		{ 0, 0, 0, 0 }
	};
#endif

   while ((opt_char =
#ifdef HAVE_GETOPT_LONG
	getopt_long(argc, argv, getopt_optstring, long_options, &opt_index)
#else
	getopt(argc, argv, getopt_optstring)
#endif
	) != EOF)
   {
      switch (opt_char)
      {
#ifdef HAVE_GETOPT_LONG
         case 0:
            printf("option %s", long_options[opt_index].name);
            if (optarg) printf(" with arg %s", optarg);
            printf("\n");
            break;
#endif
         case 'a':
            default_tagfiles_also = 1;
            break;
         case 'd':
            fprintf(stderr, "Turning on debug mode.\n");
            debug = 1;
            break;
         case 'h':
            showsyntax();
            exit(0);
            break;
         case 'v':
            printf("%s\n", version);
            exit(0);
            break;
         case '?':
            showsyntax();
            exit(0);
            break;
         default:
            fprintf(stderr,
		"?? getopt returned character code 0x%x ??\n", opt_char);
      }
   }

   init_tagdb();

   if (optind < argc)
   {
      while (optind < argc)
      {
         tf_count += open_tagfile(argv[optind]);
         optind++;
      }
   }

   if (default_tagfiles_also || (tf_count == 0))
   {
      tf_count += open_default_tagfiles();
   }

   printf("%s\n", get_random_tagline(0));
   close_tagdb();

   exit(0);
}

