//  Define the swig module name.
%module pygdssigp

//  The following code is copied verbatim to the wrapper file.
//  Note that this code is not passed through CPP
%{
#define SWIG_FILE_WITH_INIT
#include "TSeries.hh"
#include "FilterDesign.hh"
#include "Pipe.hh"
#include "gen_filter.hh"
%}

//  ANSI C/C++ wrapper declarations.

class gen_filter {
 public:
  void reset(void);
  TSeries operator()(const TSeries& t);
  TSeries apply(const TSeries& t);
};

class FilterDesign {
 public:
  FilterDesign(const char* spec, double fSample);
  ~FilterDesign(void);
};

%extend FilterDesign {
  gen_filter get_filter(void) const {
    return gen_filter(self->get());
  }
}
