#include "Pipe.hh"

class gen_filter : public Pipe {
public:
  gen_filter(void)  : mPipe(0) {}
  gen_filter(const Pipe& p) : mPipe(p.clone()) {}
  gen_filter(const gen_filter& g) : mPipe(g.clone()) {}
  ~gen_filter(void) {delete mPipe;}
  gen_filter& operator=(const gen_filter& g) {
    if (mPipe) delete mPipe;
    mPipe = g.clone();
    return *this;
  }
  TSeries apply(const TSeries& t) {return mPipe->apply(t);}
  Pipe* clone(void) const {return mPipe->clone();}
  void dataCheck(const TSeries& t) const {mPipe->dataCheck(t);}
  Time getCurrentTime(void) const {return mPipe->getCurrentTime();}
  Time getStartTime(void) const {return mPipe->getStartTime();}
  bool inUse(void) const {return mPipe->inUse();}
  void reset(void) {mPipe->reset();}
private:
  Pipe* mPipe;
};
