/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef SEG_IOHDF5_HH
#define SEG_IOHDF5_HH

#include "seg_iobase.hh"

namespace H5 {
    class CompType;
}


/**  The seg_iohdf5 class reads and writes segments to/from an hdf5 file 
  *  (potential aLigo format?).
  *  \brief Segment list I/O.
  *  \author John Zweizig
  *  \version 1.0; last modified July 27, 2011
  */
class seg_iohdf5 : public seg_iobase {
public:

    /**  Default constructor for a segment reader.
      *  \brief Default constructor
      */ 
    seg_iohdf5(void);

    /**  Destructor for an hdf5 segment reader.
      *  \brief Destructor
      */ 
    ~seg_iohdf5(void);

    /**  Read the specified segment(s) from an hdf5 input file. The segments 
      *  specified with \a select are read in from the file.
      *  If the name, ifo or version field of select is empty, all segments
      *  matching the non-empty fields are read in. If the input file does not
      *  specify the segment name, ifo  or version, the requested name, ifo
      *  and version are used.
      *  \brief Read segments from an hdf5 file.
      *  \param file    Input file name.
      *  \param select  Segment name, ifo and/or version to be selected.
      *  \param format  File format (ascii files only - ignored).
      */
    void read_seg(const std::string& file, const segID& select,  
		  const std::string& format="");

    /**  Write selected segment list(s) from the specified map to an hdf5 file.
      *  Segments matching the \a select specifier are written to the output
      *  file. If any field of the select segID is empty, all lists matching 
      *  the non-empty fields are written.
      *  \brief Write selected segment lists.
      *  \param smap   Segment map containing the segment list(s) to be written.
      *  \param select Segment ID used to select segment lists to be written.
      *  \param format Unused format specifier.
      *  \param file   Output file path.
      */
    void write_seg(const seg_map& smap, const segID& select, 
		   const std::string& format, const std::string& file);
private:
    /**  Define the hdf5 structure types used to read/write hdf5 files.
      *  \brief Define hdf5 segment structure types.
      */
    void defineTypes(void);

private:
    H5::CompType* mDefType; ///< Segment definer structure definition/
    H5::CompType* mSegType; ///< Segment structure definition.
};

#endif // !defined(SEG_IOHDF5_HH)
