#include <string>
#include <utility>
#include <vector>
#include <iostream>

#include "Dacc.hh"
#include "TSeries.hh"

//======================================  Define SegData class
class SegData {
public:
  SegData(int argc, const char* argv[]);
  ~SegData(void);
  int doit(void);
private:
  typedef std::pair<std::string, std::string> SegChan;
  typedef std::vector<SegChan> SegList;
private:
  Dacc mIn;
  SegList mList;
};

using namespace std;

//======================================  Main function
int
main(int argc, const char* argv[]) {
  SegData mySeg(argc, argv);
  return mySeg.doit();
}


//======================================  SegData constructor
SegData::SegData(int argc, const char* argv[]) {

    //----------------------------------  Get a default file name
    string file;
    if (getenv("DMTINPUT")) {
        file = getenv("DMTINPUT");
    } else if (getenv("LIGOSMPART")) {
        file = "/online/";
	file += getenv("LIGOSMPART");
    }

    //----------------------------------   Parse arguments
    bool syntax(false);
    string ifo;
    for (int i=1 ; i<argc ; i++) {
        string argi = argv[i];
	if (argi == "-infile") {
	    mIn.addFile(argv[++i]);
	    file.clear();
	} else if (argi == "-ifo") {
	    ifo = argv[++i];
	} else {
	    cerr << "Unrecognized argument: " << argi << endl;
	    syntax = true;
	}
    }
    if (!file.empty()) mIn.addFile(file.c_str());

    if (syntax || ifo.empty()) {
        cerr << "Syntax:" << endl;
	cerr << "SegData [-infile <file>] -ifo <ifo>" << endl;
        return;
    }

    //----------------------------------  Define the channel names and text
    string prefix = ifo + ":";
    mList.push_back(SegChan(prefix+"IFO-SV_SEGNUM",      "Segment Number: "));
    mList.push_back(SegChan(prefix+"IFO-SV_RUNTIME_SEC", "Run Time:       "));
    mList.push_back(SegChan(prefix+"IFO-SV_START_GPS",   "Start Time:     "));
    mList.push_back(SegChan(prefix+"IFO-SV_STOP_GPS",    "Stop Time:      "));

    mIn.setIgnoreMissingChannel(true);
    mIn.setTOCMode(true);
    for (unsigned int i=0 ; i<mList.size() ; i++) {
        mIn.addChannel(mList[i].first.c_str());
    }
}

SegData::~SegData(void) {
}

int
SegData::doit(void) {
    int rc = mIn.fillData(1.0);
    if (rc) {
        cerr << "Error reading data, rc= " << rc << endl;
	return 2;
    }
    for (unsigned int i=0 ; i<mList.size() ; i++) {
        cout << mList[i].second;
	TSeries* ts = mIn.refData(mList[i].first.c_str());
	if (ts) cout << long(ts->getDouble(0));
	else    cout << "- missing -";
	cout << endl;
    }
    return 0;
}







