/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "trender.hh"
#include "framecpp/Version6/FrameH.hh"
#include <string>
using namespace std;

using FrameCPP::Version_8::FrameH;
typedef FrameH::procData_type procData_type;
typedef FrameH::const_procData_iterator const_procData_iterator;

int debug=0;

int
main(int argc, const char* argv[]) {
   trender t(argc, argv);
   t.Loop();
}

trender::trender(int argc, const char* argv[]) {
   Trend::TrendType ttype(Trend::kMinute);
   string file_list = "input-list.txt";
   string trend_name="LIGO";
   string out_file;
   for (int i=1; i<argc; i++) {
      string argi=argv[i];
      if (argi == "-l") {
	 file_list=argv[++i];
      }
      else if (argi == "-o") {
	 out_file=argv[++i];
      }
   }

   //-----------------------------------  Set up the input reader.
   In.addFileList(file_list);
   In.setTOCMode(false);
   In.setDebug(debug);

   //-----------------------------------  Set up the trend file writer.
   string ffile = In.refList().first();
   string::size_type endir = ffile.rfind("/");
   if (endir != string::npos) ffile.erase(0, endir+1);
   string ifo = ffile.substr(0,1) + "1";
   mTrend.setName(trend_name.c_str());
   mTrend.setType(ttype);
   mTrend.setIFO(ifo.c_str());

   //-----------------------------------  Infer a frame type
   if (out_file.empty()) {
      ostringstream flout;
      const char* dir = getenv("DMTRENDIR");
      if (dir && *dir) flout << dir << "/";

      string::size_type idash = ffile.find("-") + 1;
      string::size_type jdash = ffile.find("-", idash);
      
      flout << ifo.substr(0,1) << "-" << ffile.substr(idash, jdash-idash);
      switch (ttype) {
      case Trend::kMinute:
	 flout << "_M-%s-" << 3600;
	 break;
      case Trend::kSecond:
	 flout << "_S-%s-" << 60;
	 break;
      default:
	 flout << "_M-%s-" << 1;
      }
      flout << ".gwf";
      out_file = flout.str();
   }
   mTrend.setFile(out_file.c_str());
   mTrend.setAutoUpdate(false);

   //-----------------------------------  OK to run
   active = true;
}

trender::~trender(void) {
}

void
trender::Loop(void) {

   while (active) {
      int rc = In.nextFrame();
      if (rc) break;

      Time     t0 = In.getTime();
      Interval dT = In.getDt();

      const FrameH::procData_type& pproc(In.getFrame()->RefProcData());
      if (mChanList.empty()) {
	 if (debug) cout << "Building channel list from FrProcData list ("
			 << pproc.size() << " channels)." << endl;
	 mChanList.reserve(pproc.size());
	 for (const_procData_iterator i=pproc.begin(); i != pproc.end(); i++) {
	    string chan = (*i)->GetName();
	    mChanList.push_back(Channel(chan.c_str(), 0, 0,
					Channel::kProcessed));
	    mTrend.addChannel(chan.c_str());
	    if (debug > 1) cout << "Add channel: " << chan << " to trender."
				<< endl;
	 }
      }

      size_t nChan = mChanList.size();
      for (size_t i=0; i < nChan; i++) {
	 string chan = mChanList[i].getName();
	 frprocdata_pointer p = In.findProc(chan);
	 if (!p) {
	    cerr << "FrProcData not found for channel: " << chan << endl;
	    continue;
	 }
	 mChanList[i].allocate(dT);
	 int rc = mChanList[i].FillSeries(p, t0, Interval(0), dT);
	 if (rc) {
	    cerr << "trender: Channel::Fillseries failed with rc = " << rc
		 << endl;
	    continue;
	 }
	 TSeries* ts = mChanList[i].refSeries();
	 if (!ts) {
	    cerr << "Trend data not filled for channel: " << chan << endl;
	    continue;
	 }
	 mTrend.trendData(chan.c_str(), *mChanList[i].refSeries());
      }
      In.endFrame();
      mTrend.Update(t0 + dT);
   }
}
