//////////////////////////////////////////////////////////////////////////
//  									//
//  Veto								//
//  									//
//////////////////////////////////////////////////////////////////////////

#include "events/Veto.hh"
#include "events/Event.hh"
#include "events/Argument.hh"


namespace events {

//______________________________________________________________________________
   bool Veto::Evaluate (const Argument& arg, bool& val) const
   {
      // Need at least one current!
      if (arg.GetOrder() < 1) {
         return false;
      }
      // determine start/stop time
      Time start = arg(0).GetTime() + GetOffset();
      Time stop = start + GetWidth();
      // Loop over list of events
      val = false;
      for (Argument::const_iterator i = arg.Begin(); 
          i != arg.End(); ++i) {
         // check if within window
         Time t = i->GetTime();
         if ((t < start) || (t >= stop)) {
            continue;
         }
         // check if one of the current ones
         bool isCur = false;
         for (int j = 0; j < arg.GetOrder(); ++j) {
            if (&*i == &arg(j)) {
               isCur = true;
               break;
            }
         }
         if (isCur) {
            continue;
         }
         // Found a candidate: Now check condition
         if (mCond.Get() == 0) {
            val = true; // Yes
            break;
         }
         else {
            Window win = arg.GetWindow();
            win.GetCurrentList().resize (1);
            win.SetCurrent (0, const_cast<Event*>(&*i));
            bool ret;
            if (mCond->Evaluate (win, ret) && ret) {
               val = true; // Yes
               break;
            }
         }
      }
      return true;
   }


}
