#include <time.h>
#include <stdio.h>
#include <iostream>
#include <fstream>

   using namespace std;

   // Unary oparators
   const char* const uops[] = {
   "operator+", "Pos",
   "operator-", "Neg",
   "operator~", "Not",
   "operator++", "Inc",
   "operator--", "Dec",
   "abs", "Abs",
   "sqrt", "Sqrt",
   "exp", "Exp",
   "log", "Log",
   "log10", "Log10",
   "sin", "Sin",
   "cos", "Cos",
   "tan", "Tan",
   "asin", "Asin",
   "acos", "Acos",
   "atan", "Atan",
   "sinh", "Sinh",
   "cosh", "Cosh",
   "tanh", "Tanh",
   "ceil", "Ceil",
   "floor", "Floor",
   "conj", "Conj",
   "real", "Real",
   "imag", "Imag",
   "arg", "Arg",
   "norm", "Norm",
   0, 0
   };

   // Binary oparators
   const char* const bops[] = {
   "operator+", "Add",
   "operator-", "Sub",
   "operator*", "Mul",
   "operator/", "Div",
   "operator%", "Mod",
   "operator&", "And",
   "operator|", "Or",
   "operator^", "Xor",
   "operator>>", "Right",
   "operator<<", "Left",
   "pow", "Pow",
   "atan2", "Atan2",
   "polar", "Polar",
   0, 0
   };

   // Standard type
   const char* const stdtype[] = {
   "const Function&",
   "const FunctionPtr&",
   0
   };

   // Value types
   const char* const vtypes[] = {
   "int",
   "double",
   "const std::complex<double>&",
   "const Time&",
   0
   };
   const char* const stringtype[] = {
   "const std::string&",
   "const char*",
   0};

   // Pattern for unary oparators
   const char* const upattern = 
   "inline Math %s (%s f) {\n"
   "   return Math (%s, Math::op%s); }";

   // Pattern for binary oparators
   const char* const bpattern = 
   "inline Math %s (%s f1, %s f2) {\n"
   "   return Math (%s, %s, Math::op%s); }";

   // Comment
   const char* const ucomment = "/// Math function: %s (%s)";
   const char* const bcomment = "/// Math function: %s (%s, %s)";

   int main (int argc, char** argv)
   {
      if (argc != 2) {
         cout << "usage: MAKE_MATHOPS 'header file'" << endl;
         return 1;
      }
      char buf[16*1024];
      ofstream out (argv[1]);
      out << "// ============================================= //" << endl;
      out << "// Automatically generated header: DO NOT CHANGE //" << endl;
      out << "// ============================================= //" << endl;
      out << endl;
   
      // first do: OP 'function'
      for (const char* const* stdt = stdtype; *stdt; ++stdt) {
         for (const char* const* p = uops; *p; p += 2) {
            sprintf (buf, ucomment, *p, *stdt);
            out << buf << endl;
            sprintf (buf, upattern, *p, *stdt, "f", *(p+1));
            out << buf << endl;
         }
      }
   
      // then do: 'function' OP 'function'
      for (const char* const* stdt = stdtype; *stdt; ++stdt) {
         for (const char* const* p = bops; *p; p += 2) {
            sprintf (buf, bcomment, *p, *stdt, *stdt);
            out << buf << endl;
            sprintf (buf, bpattern, *p, *stdt, *stdt, 
                    "f1", "f2", *(p+1));
            out << buf << endl;
         }
      }
      // next do: 'function' OP 'value'
      for (const char* const* stdt = stdtype; *stdt; ++stdt) {
         for (const char* const* t = vtypes; *t; t++) {
            for (const char* const* p = bops; *p; p += 2) {
               sprintf (buf, bcomment, *p, *stdt, *t);
               out << buf << endl;
               sprintf (buf, bpattern, *p, *stdt, *t, 
                       "f1", "Value(f2)", *(p+1));
               out << buf << endl;
            }
         }
      }
      // finally do: 'value' OP 'function'
      for (const char* const* stdt = stdtype; *stdt; ++stdt) {
         for (const char* const* t = vtypes; *t; t++) {
            for (const char* const* p = bops; *p; p += 2) {
               sprintf (buf, bcomment, *p, *t, *stdt);
               out << buf << endl;
               sprintf (buf, bpattern, *p, *t, *stdt, 
                       "Value(f1)", "f2", *(p+1));
               out << buf << endl;
            }
         }
      }
      // support string concatination
      for (const char* const* stdt = stdtype; *stdt; ++stdt) {
         for (const char* const* t = stringtype; *t; ++t) {
            sprintf (buf, bcomment, uops[0], *stdt, *t);
            out << buf << endl;
            sprintf (buf, bpattern, uops[0], *stdt, *t, 
                    "f1", "Value(f2)", uops[1]);
            out << buf << endl;
            sprintf (buf, bcomment, uops[0], *t, *stdt);
            out << buf << endl;
            sprintf (buf, bpattern, uops[0], *t, *stdt, 
                    "Value(f1)", "f2", uops[1]);
            out << buf << endl;
         }
      }
   }
