//////////////////////////////////////////////////////////////////////////
//  									//
//  FixedColumns							//
//  									//
//////////////////////////////////////////////////////////////////////////

#include <time.h>
#include "events/FixedColumns.hh"
#include "events/Factory.hh"


namespace events {

//______________________________________________________________________________
   bool FixedColumns::Add (const ColumnInfo& desc) 
   {
      return Factory::Get().AddFixedColumn (desc);
   }

//______________________________________________________________________________
   const ColumnInfo* FixedColumns::Get (const char* name)
   {
      return Factory::Get().GetFixedColumn (name);
   }

//______________________________________________________________________________
   const ColumnInfoList& FixedColumns::List()
   {
      return Factory::Get().FixedColumns();
   }

//______________________________________________________________________________
   int FixedColumns::VaryingNumber()
   {
      return Factory::Get().GetNextAvailableColumnNumber();
   }

//______________________________________________________________________________
   int FixedColumns::VaryingOffset()
   {
      return Factory::Get().GetNextAvailableColumnOffset();
   }

}
