//////////////////////////////////////////////////////////////////////////
//  									//
//  ConditionLogic							//
//  									//
//////////////////////////////////////////////////////////////////////////

#include "events/ConditionLogic.hh"
#include "events/Window.hh"
#include "events/Argument.hh"


namespace events {

//______________________________________________________________________________
   bool ConditionLogic::Evaluate (const Argument& arg, bool& val) const
   {
      switch (mOp) {
         case opFalse:
            {
               val = false;
               break;
            }
         case opTrue:
            {
               val = true;
               break;
            }
         case opIdentity:
            {
               if (!mPtr1.Get() || !mPtr1->Evaluate (arg, val)) {
                  return false;
               }
               break;
            }
         case opNot:
            {
               if (!mPtr1.Get() || !mPtr1->Evaluate (arg, val)) {
                  return false;
               }
               val = !val;
               break;
            }
         case opAnd:
            {
               bool v1, v2;
               if (!mPtr1.Get() || !mPtr1->Evaluate (arg, v1)) {
                  return false;
               }
               // If first argument false, don't calculate the second
               if (!v1) {
                  val = v1;
               }
               else {
                  if (!mPtr2.Get() || !mPtr2->Evaluate (arg, v2)) {
                     return false;
                  }
                  val = v1 && v2;
               }
               break;
            }
         case opOr:
            {
               bool v1, v2;
               if (!mPtr1.Get() || !mPtr1->Evaluate (arg, v1)) {
                  return false;
               }
               // If first argument true, don't calculate the second
               if (v1) {
                  val = v1;
               }
               else {
                  if (!mPtr2.Get() || !mPtr2->Evaluate (arg, v2)) {
                     return false;
                  }
                  val = v1 || v2;
               }
               break;
            }
         case opXor:
            {
               bool v1, v2;
               if (!mPtr1.Get() || !mPtr1->Evaluate (arg, v1)) {
                  return false;
               }
               if (!mPtr2.Get() || !mPtr2->Evaluate (arg, v2)) {
                  return false;
               }
               val = (v1 != 0) ^ (v2 != 0);
               break;
            }
         default:
            {
               return false;
            }
      }
      return true;
   }

//______________________________________________________________________________
   bool ShiftCondition::Evaluate (const Argument& arg, bool& val) const
   {
      // invalid parameters?
      if ((mShift < 0) || !mPtr.Get()) {
         return false;
      }
      // Shift at all?
      if (mShift == 0) {
         return mPtr->Evaluate (arg, val);
      }
      // Shift too many?
      if (mShift >= arg.GetOrder()) {
         return false;
      }
      // make a new argument list
      Window w = arg.GetWindow();
      w.GetCurrentList().erase (w.GetCurrentList().begin(), 
         w.GetCurrentList().begin() + mShift);
      // evaluate on reduced list
      return mPtr->Evaluate (w, val);
   }

}
