/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef NULL_PIPE_HH
#define NULL_PIPE_HH

#include "Pipe.hh"
#include "TSeries.hh"

/**  The Null pipe does nothing, but it may be used to simplify construction 
  *  of other trivial pipes.
  */
class NullPipe : public Pipe {
public:
    using Pipe::apply;
    using Pipe::dataCheck;
    NullPipe(void);
    virtual ~NullPipe(void);
    virtual TSeries apply(const TSeries& ts);
    virtual NullPipe* clone(void) const;
    virtual void dataCheck(const TSeries& ts) const;
    virtual Time getCurrentTime(void) const;
    virtual Time getStartTime(void) const;
    virtual bool inUse(void) const;
    virtual void reset(void);

protected:
    /** Check data is valid and keep track of start, current times
      */
    void prep(const TSeries& ts);

protected:
    Time     _start;
    Time     _current;
    Interval _step;
};

#endif // !defined(NULL_PIPE_HH)
