/* -*- mode: c++; c-basic-offset: 4; -*- */
//
//    trigRmNode - sends a message to the trigger manager instructing it 
//                 remove all processes on a specified node.
//
#include "MsgWriter.hh"
#include <string>
#include <iostream>
#include <cstdlib>

#define  PIDTITLE "Remove trigger process entries by node"
#define  PIDCVSHDR "$header$"
#include "ProcIdent.hh"

using namespace std;
using namespace lmsg;
using namespace trig;

int
main(int argc, const char* argv[]) {

    //--------------------------------------  Parse the arguments
    bool syntax = (argc < 2);
    int  debug  = 0;
    for (int i=1 ; i<argc-1 ; i++) {
        string argi = argv[i];
	if (argi == "-debug") {
	    if (++i < argc-1) debug = strtol(argv[i], 0, 0);
	    else              debug = 1;
	} else {
	    cerr << "Unrecognized argument: " << argi << endl;
	    syntax = true;
	}
    }

    if (syntax) {
        cerr << "Command syntax: " << endl;
	cerr << "trigRmNode [-debug [n]] <node>" << endl;
	return 1;
    }
    //--------------------------------------  Get unregistered trigger client
    MsgWriter tc;
    if (debug) tc.setDebug(debug);

    //--------------------------------------  Do it
    return tc.removeByNode(argv[argc-1]);
}
