/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "TrigMsg.hh"
#include "lmsg/TransInput.hh"
#include "lmsg/TransOutput.hh"
#include <iostream>
#include <string.h>

using namespace std;
using namespace trig;

template<class T, unsigned int MsgID>
TrigMgrMsg<T, MsgID>::TrigMgrMsg(void) {
}

template<class T, unsigned int MsgID>
TrigMgrMsg<T, MsgID>::~TrigMgrMsg(void) {
}

template<class T, unsigned int MsgID>
TrigMgrMsg<T, MsgID>::TrigMgrMsg(const T& ival) 
  : mValue(ival)
{
}

template<class T, unsigned int MsgID>
TrigMgrMsg<T, MsgID>::TrigMgrMsg(lmsg::TransInput& istr) {
    setData(istr);
}

//--------------------------------------  Set data methods
template<>
void
TMM_Trigger::setData(lmsg::TransInput& istr) throw(runtime_error) {
    string ID, SubID, Process, Ifo;
    Time Ts;
    double dTime, Size, Sig, Freq, BW;
    int    prio, disp;

    double PeakTime, AvgTime, TimeSigma, FreqPeak, FreqAvg, FreqSigma;
    double NoisePower, SignalPower, Confidence;
    int    PixelCount;


    istr >> Process >> ID >> SubID >> Ts >> dTime >> Size >> Sig 
	 >> Freq >> Ifo >> prio >> disp >> BW >> PeakTime >> AvgTime 
	 >> TimeSigma >> FreqPeak >> FreqAvg >> FreqSigma >> NoisePower 
	 >> SignalPower >> PixelCount >> Confidence;
    mValue = TrigBase(ID.c_str(), SubID.c_str(), Ts, dTime, Size, Sig, 
		      Freq, Ifo.c_str());
    mValue.setProcess(Process.c_str());
    mValue.setPriority(TrigPrio(prio));
    mValue.setDisposition(disp);
    mValue.setBandwidth(BW);
    mValue.setPeakOffset(PeakTime);
    mValue.setAvgOffset(AvgTime);
    mValue.setTimeSigma(TimeSigma);
    mValue.setFreqPeak(FreqPeak);
    mValue.setFreqAvg(FreqAvg);
    mValue.setFreqSigma(FreqSigma);
    mValue.setNoisePower(NoisePower);
    mValue.setSignalPower(SignalPower);
    mValue.setPixelCount(PixelCount);
    mValue.setConfidence(Confidence);

    //----------------------------------  Set the result data.
    int len;
    istr >> len;
    char* data = new char[len];
    istr.read(data, len);
    mValue.setData(data, len);
    delete[] data;
}

template<>
void
TMM_Register::setData(lmsg::TransInput& in) throw(runtime_error) {
    string Source, Version, Host, IFOs, Author, Title, Exec, DBaseID;
    lmsg::gps_export_type Start, Mod, End;
    pid_t PID;
    int Online;
    in >> Source >> Version >> Start >> Host >> PID >> Online 
       >> IFOs >> Author >> Mod >> Title >> Exec >> End >> DBaseID;
    mValue = TrigProc(Source.c_str(), Version.c_str(), Start, Host.c_str(), 
		      PID, Online, IFOs.c_str(), Author.c_str(), Mod, 
		      Title.c_str(), Exec.c_str(), End);
    mValue.setProcessID(DBaseID);
}

template<>
void
TMM_Segment::setData(lmsg::TransInput& istr) throw(runtime_error) {
    string Group, Process, ifos, comment;
    Time Tstart, Tend;
    int version, activity;
    istr >> Process  >> Group   >> version >> Tstart >> Tend >> ifos 
	 >> activity >> comment;
    mValue = Segment(Group.c_str(), version, Tstart, Tend);
    mValue.setProcess(Process.c_str());
    mValue.setIfos(ifos.c_str());
    mValue.setComment(comment);
    mValue.setActivity(activity);
}

template<class T, unsigned int MsgID>
void
TrigMgrMsg<T, MsgID>::setData(lmsg::TransInput& istr) throw(runtime_error) {
    istr >> mValue;
}

//--------------------------------------  Get data methods
template<>
void
TMM_Trigger::getData(lmsg::TransOutput& out) const {
    out << string(mValue.getProcess())    << string(mValue.getID())
	<< string(mValue.getSubID())      << mValue.getTime()
	<< double(mValue.getDt())         << mValue.getIntensity() 
	<< mValue.getSignificance()       << mValue.getLowF()
	<< string(mValue.getIFOs())       << int(mValue.getPriority())
	<< mValue.getDisposition()        << mValue.getBandwidth()
	<< double(mValue.getPeakOffset()) << double(mValue.getAvgOffset())
	<< double(mValue.getTimeSigma())  << mValue.getFreqPeak() 
	<< mValue.getFreqAvg()            << mValue.getFreqSigma() 
	<< mValue.getNoisePower()         << mValue.getSignalPower() 
	<< mValue.getPixelCount()         << mValue.getConfidence();
    int len = mValue.getDataLength();
    out << len;
    out.write(mValue.getResult(), len);
}

template<>
void
TMM_Register::getData(lmsg::TransOutput& out) const {
    out << mValue.getSource()
	<< mValue.getVersion()
	<< lmsg::gps_export_type(mValue.getStartTime())
	<< mValue.getNode()
	<< mValue.getProcID()
	<< int(mValue.isOnline())
	<< mValue.getIFOs()
	<< mValue.getAuthor()
	<< lmsg::gps_export_type(mValue.getModTime())
	<< mValue.getTitle()
	<< mValue.getName()
	<< lmsg::gps_export_type(mValue.getEndTime())
        << mValue.getProcessID();
}

template<>
void
TMM_Segment::getData(lmsg::TransOutput& out) const {
    out << string(mValue.getProcess()) << string(mValue.getGroup())
	<< mValue.getVersion()         << mValue.getStartTime()
	<< mValue.getEndTime()         << string(mValue.getIfos()) 
	<< mValue.getActivity()        << string(mValue.getComment());
}

template<class T, unsigned int MsgID>
void
TrigMgrMsg<T, MsgID>::getData(lmsg::TransOutput& ostr) const {
    ostr << mValue;
}

//--------------------------------------  Get value methods
template<class T, unsigned int MsgID>
const T&
TrigMgrMsg<T, MsgID>::refValue(void) const {
    return mValue;
}

template<class T, unsigned int MsgID>
T&
TrigMgrMsg<T, MsgID>::refValue(void) {
    return mValue;
}

template<class T, unsigned int MsgID>
lmsg::size_type 
TrigMgrMsg<T, MsgID>::size(void) const {
    return sizeof(T);
}

template<class T, unsigned int MsgID>
lmsg::MsgHeader::MsgType
TrigMgrMsg<T, MsgID>::getType(void) const {
    return MsgID;
}

//--------------------------------------------  Explicit instantiations
template class TrigMgrMsg<TrigProc, tmm_Register>;
template class TrigMgrMsg<TrigBase, tmm_Trigger>;
template class TrigMgrMsg<Segment,  tmm_Segment>;
template class TrigMgrMsg<string,   tmm_ProcID>;
template class TrigMgrMsg<string,   tmm_Close>;
template class TrigMgrMsg<string,   tmm_rmNode>;
template class TrigMgrMsg<string,   tmm_reConfig>;
