/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef TRIG_PROCTABLE_HH
#define TRIG_PROCTABLE_HH

#include "xsil/MetaTable.hh"
#include <string>

namespace trig {

    static const int nProcessKeyBytes = 13;

    class TrigProc;

    /**  Define data types used by the database.
      */
    namespace DBTypes {
	typedef float       real_4;
	typedef double      real_8;
	typedef int         integer_4;
	typedef std::string lstring;
	typedef std::string varchar;
	typedef std::string character;
    }

    /**  The ProcTable class is a meta-database interface producing an xsil 
      *  meta database table.
      */
    class ProcTable : public xsil::MetaTable {
    public:
	/**  Construct a process table. The alphaPID parameter determines the 
	  *  format of the process id entries. if #alphaPID=true#, the process
	  *  ID is specified as a process table row id, e.g. 
	  *  #process:Process_id:0#. If #alphaPID=false#, an external 26-byte 
	  *  process key is specified that must be compressed into a 13-byte 
	  *  BCD field.
	  */
	ProcTable(bool alphaPID=false);

	/**  Destroy the process table.
	  */
	~ProcTable(void);

	/**  Add a process row to the table.
	  *  @param s trigger process desctiptor
	  *  @return row number containinf the added process.
	  */
	int addRow(const TrigProc& s);

	/**  Check the process name.
	  */
	void check(const char* title) const;

	/**  Pack a process key string.
	 */
	static void packKey(int len, const char* in, unsigned char* out);

    private:
	void setColumns(void);
    private:
	DBTypes::character program;
	DBTypes::varchar   version;
	DBTypes::varchar   cvsname;
	DBTypes::integer_4 cvstime;
	DBTypes::varchar   comment;
	DBTypes::varchar   node;
	DBTypes::character username;
	DBTypes::integer_4 unix_procid;
	DBTypes::integer_4 start_time;
	DBTypes::integer_4 end_time;
	DBTypes::character ifo;
    
	//------------------------------  UCVec and its data vectors.
	int proc_id_length;
	unsigned char processID[nProcessKeyBytes];
	xsil::UCVec process_id;

	//------------------------------  Alternative process ID
	bool altPID;
	DBTypes::character PIDstr;
    };
}

#endif // TRIG_PROCTABLE_HH

