#include "DVector.hh"
#include "ConfContainer.hh"
#include "FilterDesign.hh"

   using namespace std;

//
//  ThresholdInfo
//
   void ThresholdInfo::Dump () {
      std::string type;
      if (fType == kAbs) type = "Abs";
      else type = "Rel";
      cout << type << "\t" << fLow << "(sigma)\t" << fHigh << "(sigma)\t";
   }

//
//  Parameter
//
   void Parameter::Dump() {
      cout << fMinSeparation.GetSecs() << "(sec)\t" << fMinDuration.GetSecs()
         << "(sec)\t" << fMaxDuration.GetSecs() << "(sec)\t" 
         << fMinDensity << "\t";
   }

//
//  FilterInfo
//
   void FilterInfo::Dump () {
   
      cout << fName << "\t" << fFormula << "\t" << fLPEFLength << "\t" << fLPEFTrainPeriod << "\t" << fLPEFTrainLength << endl;
   }


   Pipe* FilterInfo::GetFilter ( double fs ) {
      FilterDesign fd ( fs );
      if ( !fd.filter( fFormula.c_str() ) ) {
         cerr << "invalid filter. " << fFormula << endl;
         return 0;
      }
      return fd.release();
   }


   std::string FilterInfo::GetFilterFormulaAll() const {
      ostringstream formula;
      formula << fFormula.c_str() << " + LPEF(" 
         << fLPEFLength << "," 
         << fLPEFTrainPeriod << "," 
         << fLPEFTrainLength << ")" << endl;
      return formula.str();
   }

//
//  EventInfo
//
   EventInfo& EventInfo::operator= (const EventInfo& einfo) {
      fChannel = einfo.fChannel;
      fEventStatus = einfo.fEventStatus;
      fStartTime = einfo.fStartTime;
      fEndTime = einfo.fEndTime;
      fMaxTime = einfo.fMaxTime;
      fMaxData = einfo.fMaxData;
      fMaxSDev = einfo.fMaxSDev;
      fMaxMean = einfo.fMaxMean;
      fEventNPoint = einfo.fEventNPoint;
      fIfo = einfo.fIfo;
      fComment = einfo.fComment;
   
      return *this;
   }

   void EventInfo::Dump( ostream& out ) {
      out << "\"" << fChannel << "\"" << ","
         << "\"" << fIfo << "\"" << ","
         << fStartTime.getS() << ","
         << fStartTime.getN() << ","
         << (fEndTime - fStartTime) << ","
         << (fMaxTime - fStartTime) << ","
         << fMaxData << "," << fMaxSDev << "," << fMaxMean << "," 
         << fEventNPoint << "," 
         << "\"" << fComment << "\"";
   }
