// this class reads the configuration file for the rms monitor
#ifndef RmsConfig_HH
#define RmsConfig_HH

#include <string>

const int max_channame_length=60;
const int max_file_path_length=200;

class RmsConfig {

public:

  RmsConfig(const std::string& input_param_file_name,
	    const std::string& output_param_file_name,
	    const std::string& update_param_file_name);
  int PrintChannelNames();
  int number_of_channels;
  ~RmsConfig();

  char** channel_names;
  float** flag_level;  //Quality Flag Trigger Level --> Set in Config File
  std::string input_filename;
  std::string output_filename;
  std::string update_filename;
  std::string filter_filename;

  char** dqflag_names;        //stores DQ flag names from config file
  char** dqflag_channel_names; //stores channel name + band to be monitored for a flag
  float dqflag_thresholds[1000];
  int dqflag_count;

  char** dqflag_comments;     //stores the comment for each data quality flag

  int secs_per_rms_reading;

private:

  //const int max_channame_length = 30;
  //const int max_outfile_path_length = 100;

};

#endif // RmsConfig_HH


