/* -*- mode: c++; c-basic-offset: 4; -*- */
// implementation of class to read config file

#include <cstdlib>
#include <cstdio>
#include <cstring>
#include "RmsConfig.hh"
#include <iostream>

using namespace std;

RmsConfig::RmsConfig(const string& input_param_file_name, 
		     const string& output_param_file_name,
		     const string& update_param_file_name )
    : input_filename(input_param_file_name),
      output_filename(output_param_file_name), 
      update_filename(update_param_file_name)
{
	
    FILE* in=fopen(input_param_file_name.c_str(),"r");
    if (in == NULL) {
	cerr << "ERROR: cannot open " << input_param_file_name << "." << endl;
	exit(0);
    }

    if (fscanf(in, "%d\n", &number_of_channels) != 1) {
	cerr << "Error in blrms config file syntax." << endl;
	exit(0);
    }

    channel_names = new char* [number_of_channels];

    for (int i=0; i<number_of_channels; ++i) {
	channel_names[i] = new char [ max_channame_length ];
	if (fscanf( in , "%s\n", channel_names[i]) <= 0) {
	    cerr << "Error in blrms config file syntax. " 
		 << i << "/" << number_of_channels << " channels found." 
		 << endl;
	    exit(0);
	}
    }

    char temp[1000];
    if (fscanf(in, "%d\n", &secs_per_rms_reading) < 1 ||
	fscanf(in, "%s\n", temp) < 1) {
	cerr << "Error in blrms config file syntax." << endl;
	exit(0);
    }
    filter_filename = temp;

    dqflag_count=0;

    dqflag_names=new char*[1000];
    dqflag_channel_names=new char*[1000];
    dqflag_comments=new char*[1000];
	
    while( ! feof (in)) {
		
	dqflag_names[dqflag_count]=new char [max_channame_length];
	dqflag_channel_names[dqflag_count]=new char [max_channame_length];
	char* pcom = new char [1000];
	dqflag_comments[dqflag_count] = pcom;
	*pcom = 0;

	if (fscanf(in, "%s", dqflag_names[dqflag_count]) == 1 &&
	    fscanf(in, "%s", dqflag_channel_names[dqflag_count]) == 1 &&
	    fscanf(in, "%f", dqflag_thresholds+dqflag_count) == 1) {

	    //------------------  Throws away the rest of the line and
	    //                    read the next line
	    char garbage[10000];
	    if (fgets(garbage, 10000, in) == NULL) break; 
	    if (fgets(dqflag_comments[dqflag_count], 1000, in) == NULL) break;

	    int coml = strlen(pcom);
	    if (coml && pcom[coml-1] == '\n') pcom[coml-1] = 0;
	    printf("%s %s %f  %s\n", 
		   dqflag_names[dqflag_count], 
		   dqflag_channel_names[dqflag_count],
		   dqflag_thresholds[dqflag_count],
		   dqflag_comments[dqflag_count]);
	    dqflag_count++;
	}
	else {
	    break;
	}
    }

    fclose(in);
}

int
RmsConfig::PrintChannelNames() 
{
    for(int i=0;i<number_of_channels;++i) 
	{
	    // KSG 9/17/05 The following printf changed by KSG
	    //printf("%s\n",channel_names[i]);
	    printf("DMT-BRMS_%s\n",channel_names[i]);
	}
    return 0;
}

RmsConfig::~RmsConfig()
{
    for(int i=0; i<number_of_channels; ++i) {
	delete [] channel_names[i];
    }
    for(int i=0; i<dqflag_count; ++i) {
	delete [] dqflag_channel_names[i];
	delete [] dqflag_names[i];
    }
    delete [] channel_names;
    delete [] dqflag_channel_names;
    delete [] dqflag_names;
}
