#include <fstream>
#include <iostream>
#include <cstdio>
#include <sys/stat.h>

#include "DatEnv.hh"
#include "Sine.hh"
#include "TSeries.hh"
#include "FSeries.hh"
#include "FSpectrum.hh"
#include "Hanning.hh"
#include "xsil/XSpectrum.hh"
#include "xsil/Xwriter.hh"

class SpectrumArchiver : public DatEnv {

  public:
    SpectrumArchiver(int argc, const char *argv[]);
    ~SpectrumArchiver();
    void ProcessData(void);
    void Configuration(void);
    void WriteXML(char *path, char **names, int channelIndex);

    std::ofstream fileStream;

    TSeries *currentTimeSeries;
    TSeries fineWindowedTimeSeriesSegment, coarseWindowedTimeSeriesSegment;

    char observatoryName[3];
    int numberChannels;
    char **channelNames;

    Time currentTime, startTime;
    char currentGPSTime[15];
    char currentUTCTime[100];
    char year[5];
    char month[10];
    char day[4];
    char hour[4];

    char archiveLocation[50];
    char topLevelPath[80];
    char currentPath[80];
    char currentArchivePath[100];
    char tempString[10];
    char thisChannelName[50];

    int numberFrequencyPoints;
    FSpectrum finePowerSpectrum, coarsePowerSpectrum;
    Interval fineSegmentLength, coarseSegmentLength;
    double samplingRate;
    Hanning HanningWindow;
    float fineAmplitudeData[10001], coarseAmplitudeData[8193];
  float data[20];
};
