/* -*- mode: c++; c-basic-offset: 3; -*- */
#ifndef THTFD_HH
#define THTFD_HH
#include "TH2.h"

/** Time-frequency histogram class.
 *
 */
class THTFD : public TH2D {
public:
   THTFD(void);
   THTFD(const char *name, const char *title, Int_t nbinsx, Double_t xlow,
	 Double_t xup, Int_t nbinsy,Double_t ylow,Double_t yup);
   THTFD(const char *name, const char *title, Int_t nbinsx, Double_t xlow,
	 Double_t xup, Int_t nbinsy, const Double_t *ybins);
   void ShiftX(Int_t nx, const Double_t* col, Bool_t update_axis=false);
};

#endif // !defined(THTFD_HH)
