/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "RayleighConfig.hh"
#include <iostream>

//====================================== Constructor.  
RayleighConfig::RayleighConfig(const char* input_param_file_name )
{
    FILE* in;
    if ( (in=fopen(input_param_file_name,"r")) == NULL ) {
      std::printf("ERROR: cannot open %s.\n",input_param_file_name);
      //exit(0);  // monitor will crash below:
    } else {
      int l;
      l = std::fscanf(in,"%lf",&Stride);
      l = std::fscanf(in,"%d",&N);
      l = std::fscanf(in,"%d",&MaxStride);
      l = std::fscanf(in,"%d",&number_of_channels);
      channel_names = new char* [number_of_channels];
      f_lower = new double[number_of_channels];
      f_upper = new double[number_of_channels];
      channel_rates = new int[number_of_channels];
      for(int i=0;i<number_of_channels;++i) {
        channel_names[i] = new char [ max_channame_length ];
        l = std::fscanf(in, "%s%d%lf%lf", channel_names[i], channel_rates+i,			f_lower+i, f_upper+i);
      }
      fclose(in);
    }
}


//====================================== Destructor.  
RayleighConfig::~RayleighConfig()
{
    for(int i=0;i<number_of_channels;++i) {
      delete [] channel_names[i];
    }
    delete [] channel_names;
}


//====================================== Make sure N, Stride are okay.  
bool
RayleighConfig::CheckParameters() 
{
    bool okay = true;
    
    //-------------------- Check that Stride = Integer * 2^{-14}.
    //                     (2^{-14} = 0.006103515625).  :KLUDGE:
    //                     Should check instead that stride 
    //                     is multiple of 1/sampling rate of 
    //                     SLOWEST selected channel.
    //                     [Powers of 2 should be free of roundoff
    //                     error, so don't check for that.]
    int stride_check = int(16384*Stride);
    double decimal_part = 16384*Stride - ((double) stride_check); 
    if (decimal_part != 0.0) {
        std::cerr << "FATAL: Decimal part of Stride must be multiple ";
        std::cerr << "of 1/16384 = 2^{-14}.  EXITING.\n";
        okay = false;
    }

    //-------------------- Check that N > 1.  Can't get variance 
    //                     of a single sample!
    if (N <= 1) {
        std::cerr << "FATAL: Must have N > 1.  EXITING.\n";  
        okay = false;
    }
    
    return okay;
}
