
// FOMpulsar.cc
// This function will calculate the FOM1,FOM2, FOM3 for pulsars: Strain Sensitivity h for Pulsars
// against Noise curve for 1 day, run duration, 1 year
//

#include <iostream>
#include <fstream>
#include <math.h>
#include "FOMpulsar.hh"

using namespace std;

// this function reads the ANTF catalog
void  GetPulsarData(float NumP[], float FreqP[], float FdotP[], float DistP[], 
		    float Mult[], float NumPEC[], float FreqPEC[], 
		    float FdotPEC[], float DistPEC[], float MultEC[]  );

void FOM1_pul(float NumpulsEC[], float FreqpulsEC[],float FdotpulsEC[],
	      float DistpulsEC[], float FreqIFOEC[],float hof[], 
	      float MultEC[], int BINS1, float HPULEC[] );
void FOM2_pul(float NumpulsEC[],float FreqpulsEC[],float FdotpulsEC[], 
	      float DistpulsEC[], float FreqIFOEC[],float hof[], 
	      float MultEC[], float THEC[]);
void FOM3_pul(float Numpuls[],float  Freqpuls[],float Fdotpuls[],
	      float Distpuls[],float FreqIFO[], float hof[], float Mult[], 
	      float EPSI[]);

//physical constants
// float G=6.67E-11;// N m^2/kg^2 Gravitational Constant
/// float c=3e+8;// m/s speed of light
// float I=1e+45; // moment of Inertia of neutron star

const int LengthCat1=5200; 

float FOMPulsar(float *strainvalues, float *freqIFO, int lengthPSD,
		float *hPulsarEC, float *ThEC, float *Epsilon_Run){


int bins1=lengthPSD;

float Num_puls[LengthCat1];       // the array to store the ANTF catalog number of the pulsars  
float Freq_puls[LengthCat1];    // the array to store the frequency of the pulsars
float Fdot_puls[LengthCat1];    // the array to store the freq. derivative of the pulsars
float Dist_puls[LengthCat1];    // the array to store the distance (in kpc) of the pulsars
float mult[LengthCat1];

float Num_pulsEC[LengthCat1];       // the array to store the ANTF catalog number of the pulsars  
float Freq_pulsEC[LengthCat1];    // the array to store the frequency of the pulsars
float Fdot_pulsEC[LengthCat1];    // the array to store the freq. derivative of the pulsars
float Dist_pulsEC[LengthCat1];    // the array to store the distance (in kpc) of the pulsars
float multEC[LengthCat1];


// float ThEC_f[LengthCat1];

//float *Freq_IFO=new float[bins1+1];          // the frequency sequence for the IFO
//float *ho_f=new float[bins1+1];
  
  
  
 GetPulsarData(Num_puls, Freq_puls, Fdot_puls, Dist_puls, mult, Num_pulsEC, 
	       Freq_pulsEC, Fdot_pulsEC, Dist_pulsEC, multEC);

 float* Freq_IFO=freqIFO;
 float* ho_f=strainvalues;


 // for (int i=0;i<=bins1;i++){

//  cerr<<"i="<<i<<" "<<"freq="<<freqIFO[i]<<endl;

//  Freq_IFO[i]=freqIFO[i];
 // ho_f[i]=strainvalues[i];
  //  }
// setting variables names



//GethNoiseCurve(Freq_IFO, ho_f);
//    cerr<<" I arrive here 4th "<<endl;
  FOM1_pul(Num_pulsEC, Freq_pulsEC, Fdot_pulsEC, Dist_pulsEC, Freq_IFO, ho_f, 
	   multEC,  bins1, hPulsarEC);
  FOM2_pul(Num_pulsEC, Freq_pulsEC, Fdot_pulsEC, Dist_pulsEC, Freq_IFO, ho_f, 
	   multEC, ThEC  );
  FOM3_pul(Num_puls, Freq_puls, Fdot_puls, Dist_puls, Freq_IFO, ho_f, mult, 
	   Epsilon_Run );
  return 100.1;

  //delete[] Freq_IFO;
  //delete[] ho_f;


}





void GetPulsarData(float *Num_puls, float *Freq_puls, float *Fdot_puls, 
		   float *Dist_puls, float *mult, float *Num_pulsEC, 
		   float *Freq_pulsEC, float *Fdot_pulsEC, float *Dist_pulsEC, 
		   float *multEC)
{

//float *FreqErr_puls; // the array to store the error margin of the frequency of the pulsars
//float *FdotErr_puls; // the array to store the error margin of the freq. derivative of the pulsars


//FreqErr_puls=new float[LengthCat1]; // the array to store the error margin of the frequency of the pulsars
//FdotErr_puls=new float[LengthCat1]; // the array to store the error margin of the freq. derivative of the pulsars


   int   i;        	// used for array counting variable

   ifstream indata;
   ifstream indata11;	

   indata.open("ATNF6order.txt");// opens the file where the ANTF pulsars data is stored
   indata11.open("ATNF6orderEC.txt");// opens the file where the ANTF pulsars data is stored for EC calculations
   
   
   for (i=0;i<=LengthCat1;i++)
   
   	{
   	  Num_puls[i]=0;
   	  Num_pulsEC[i]=0;
   	  
   	  Freq_puls[i]=0;
   	  Freq_pulsEC[i]=0;
   	  
   	 // FreqErr_puls[i]=0;
   	  Fdot_puls[i]=0;
   	  Fdot_pulsEC[i]=0;
   	  
   	 // FdotErr_puls[i]=0;
   	  Dist_puls[i]=0;
   	  Dist_pulsEC[i]=0;
   	  
   	  mult[i]=0;
   	  multEC[i]=0;
   	}


   for (i=0;i<=LengthCat1;i++)
   
   	{
   	  indata>>Num_puls[i]>>Freq_puls[i]>>Fdot_puls[i]>>Dist_puls[i]>>mult[i];
   	  indata11>>Num_pulsEC[i]>>Freq_pulsEC[i]>>Fdot_pulsEC[i]>>Dist_pulsEC[i]>>multEC[i];
   	}

   indata.close();
   indata11.close();     
 

}



void  FOM1_pul(float *Num_pulsEC, float *Freq_pulsEC, float *Fdot_pulsEC, 
	       float *Dist_pulsEC, float *Freq_IFO,float *ho_f, float *multEC, 
	       int bins1, float *hPulsarEC )
{       

        int   i;        	// used for array counting variable
        
   	  
        
        float PdotEC[LengthCat1];   //Pdot for pulsars 
       
       // float Freq_puls_f[LengthCat1];
 
      ofstream outdata;	
     //  ofstream outdata1;
      
      outdata.open("h_EC_pulsarsNOW.txt",ios::trunc);// opens output file for the h Energy Conservation
      // outdata1.open("hoTyear.txt",ios::trunc);// opens output file for the h for integration 1 year
 
            
     for (i=0; i<=LengthCat1; i++)
         
         {  
         
           
            PdotEC[i]=0; 
            PdotEC[i]= fabs(Fdot_pulsEC[i])*pow(Freq_pulsEC[i]/2,-2);// frequencies are given at 2 times rot.
            hPulsarEC[i]=0;
            hPulsarEC[i]= 5.7e-24/Dist_pulsEC[i] * sqrt( fabs(Freq_pulsEC[i]) /1000 * PdotEC[i] /1e-13 )*multEC[i];//amplitude of GW at EC        
            // mult is 1 if pulsar is in the IFO freq bin, mult is 0 otherwise

                             
          outdata<<Num_pulsEC[i]<<' '<<Freq_pulsEC[i]<<' '<<hPulsarEC[i]<<endl;
          cerr<<hPulsarEC[i]<<endl; 
         //cout<<i<<endl;
           
          }

            hPulsarEC[0]=0;
            hPulsarEC[1]=0;
            
         outdata.close();
        
  

}



void  FOM2_pul(float *Num_pulsEC, float *Freq_pulsEC, float *Fdot_pulsEC, float *Dist_pulsEC, float *Freq_IFO, float *ho_f, float *multEC, float *ThEC_f)
{        
    //    int bins1=1400;
 
        int   iii=0;        	// used for array counting variable
        int kkk=0;
         
     //   float Tyear=365*60*60*24; // seconds in 1 year integration time
     // float Tday=60*60*24; // seconds in 1 day integration time
      //  float diff;      
      
   	float ho_EC[LengthCat1];  // h for radiation of pulsars at Energy Conservation limit
        float PdotEC[LengthCat1];   //Pdot for pulsars 
        float ThEC[LengthCat1];   //integration time T required to reach sensitivity at Energy Conservation limit
        float Snoise_f[LengthCat1]; // The PSD of the detector

      //  float Freq_puls_f[LengthCat1];
 
           	
     //  ofstream outdata2;
      // ofstream outdata22;

     //  outdata2.open("ThEC.txt",ios::trunc);// opens output file for the time required to reach sensitivity to hE
    //   outdata22.open("ThEC_f.txt",ios::trunc);// opens output file for the time required to reach sensitivity to hE
         


        for (iii=0; iii<=LengthCat1; iii++)
         
         {  
         Freq_IFO[0]=0.5;// here obtain the minimum Freq_IFO CHANGE !!!
           
         kkk=0; 
         
         if ( Freq_pulsEC[iii] > Freq_IFO[0]){ 
            
         while( fabs( Freq_IFO[0]+kkk*0.25-Freq_pulsEC[iii] ) > 0.25/2 )
         { kkk++; 
         }
         
      
            Snoise_f[iii]=ho_f[kkk]*ho_f[kkk];//Freq_puls is the emission frequency (double the rotation frequency)
            
            PdotEC[iii]=0; 
            PdotEC[iii]= fabs(Fdot_pulsEC[iii])/(Freq_pulsEC[iii]/2)/(Freq_pulsEC[iii]/2);
            ho_EC[iii]=0;
            ho_EC[iii]= 5.7e-24/Dist_pulsEC[iii] * sqrt( fabs(Freq_pulsEC[iii]) /1000 * PdotEC[iii] /1e-13 );//amplitude of GW at EC        
            ThEC[iii]=11.4*11.4*Snoise_f[iii]/ho_EC[iii]/ho_EC[iii]*multEC[iii]/60/60/24 ;// again here pulsar present mult=1, 0 otherwise time is in days
                                       
                                           }
                                            
            else{ ThEC[iii]=1e-36; }
           
           }
                                           
           
}


void  FOM3_pul(float *Num_puls, float *Freq_puls, float *Fdot_puls, float *Dist_puls, float *Freq_IFO, float *ho_f, float *mult, float *Epsilon_Run)
{
      //  int bins1=1400;

        int   i;        	// used for array counting variable
        int k;
         
    //    float Tyear=365*60*60*24; // seconds in 1 year integration time
   	
   	float Tday=60*60*24; // seconds in 1 day integration time
   	float run_sec=70*Tday;// run duration in seconds
 
  //      float diff;      
      
   	float epsilon_run[LengthCat1];  // ellipticity epsilon for radiation of pulsars at Sensistivity limit for run duration
        float h0_run[LengthCat1];// Sensitivity of Detector at run duration
//        float Pdot[LengthCat];   //Pdot for pulsars 
        //float Freq_puls_f[LengthCat1];

       	
       //ofstream outdata3;
       //ofstream outdata33;
       //outdata3.open("Epsilonrun.txt",ios::trunc);// opens output file for known pulsars ellipticity
      // outdata33.open("Epsilonrun_f.txt",ios::trunc);// opens output file for known pulsars ellipticity
  	
   	
    for (i=0; i<=LengthCat1; i++)
         
         {  
       Freq_IFO[0]=0.5;
           
          k=0; 
       // min freq to display 50 Hz
         
        if ( Freq_puls[i] > 50 ){
    
         while( fabs( Freq_IFO[0]+k*0.25-Freq_puls[i] ) > 0.25/2 )
         { k++; 
       //  cerr<<k<<" "<<"k"<<endl;

         } 
                 
            h0_run[i]=0;
            h0_run[i]=11.4*ho_f[k]/sqrt(run_sec);
            
            epsilon_run[i]=0;
            epsilon_run[i]= 9.5e-6*Dist_puls[i] * pow( fabs( Freq_puls[i] )/1000,-2) * h0_run[i]/1e-23*mult[i] ;//epsilon at sensitivity limit at run duration           
                                          }
            else{ epsilon_run[i]=1e-36; }                              

          }
         


}



