/* -*- mode: c++; c-basic-offset: 4; -*- */
//
//  Function FOM4CumSpectrum:  Helper function for PulsarMon.  Reads an
//  FSpectrum "psd" and copies FOM4: Cumulative Spectrum over Run Period  into a second
//  FSpectrum "out".
//
///////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include <iostream>
#include <fstream>
#include <math.h>

#include "FOM4CumSpectrum.hh"

using namespace std;

void FOM4CumSpectrum( int NStride, FSpectrum& out1, FSpectrum& psd, FSpectrum& out2, FSpectrum& cumsold)
{ 
   //----- Set FSpectrum out1 equal to FSpectrum psd.
    out1 = psd;
    //----- Set FSpectrum out2 equal to FSpectrum cumsold .
    out2=cumsold;
    // cumsold is really the sqrt of cumsold; this is done to deal with 
    // float to double conversion
    //----- Initialize items necessary to calculation.
    int nsteps = out1.getNStep();
    float Tst=60.00;// length of one stride in seconds

    // float low_freq = out1.getLowFreq();
    // float f_step = out1.getFStep();
    float *data = new float[nsteps + 1];
    float *data1= new float[nsteps + 1];
    double *dataD = new double[nsteps + 1];
    double *CumS= new double[nsteps + 1];
    double *CumS2= new double[nsteps + 1];    
    double *PSD1 = new double[nsteps +1];

    //----- Copy data from out object to data array.
    out1.getData(nsteps + 1, data);
    out2.getData(nsteps +1, data1);    
                     
    for (int i=0; i < (nsteps + 1) ;i++)
    {
	dataD[i] = (double) data[i];
	CumS[i]= (double) data1[i];
    }
           
    // Calculation of Cumulative Spectrum	
    for (int i = 0; i < (nsteps + 1); i++)
    {
	// double datafreq = low_freq + f_step*i;
	PSD1[i]=  dataD[i]*dataD[i];
	CumS2[i]= CumS[i]*CumS[i];
	CumS2[i]=  CumS2[i] + 1/PSD1[i];  
	data[i] = sqrt(1/Tst *1/CumS2[i]);
	data1[i]=sqrt(CumS2[i]);
    }

    //----- Send data back to FSpectrum object.
    out1.setData(nsteps + 1, data);
    out2.setData(nsteps + 1, data1);
       
    delete [] data;
    delete [] data1;
    delete [] PSD1; 
    delete [] CumS;
    delete [] CumS2;
    delete [] dataD;
  	
}

