#ifndef PSLSPEC_HH
#define PSLSPEC_HH

#include "FSpectrum.hh"
#include "Time.hh"
#include <string>

class PSLChan;

//======================================  Spectrum monitor class
class PSLSpec {
public:
  //------------------------------------  Constructors and destructors.
  PSLSpec(const std::string& name, const PSLChan* chan);
  PSLSpec(const PSLSpec& x);
  ~PSLSpec(void);

  //------------------------------------  Acessors.
  const char* getChannel(void) const;
  const char* getEnableCond(void) const;
  const char* getName(void) const;
  const FSpectrum& refAverage(void) const;

  //------------------------------------  Mutators
  void setAvg(Interval avgTime);
  void setCompare(const FSpectrum& sp);
  void setSave(Interval savTime, const std::string& savFile);
  void setEnableCond(const std::string& cond);

  //------------------------------------  Processing functions
  bool crunch(void);
  void reset(void);

private:
  std::string    mName;
  const PSLChan*  mChan;

  Time      mAvStart;
  Interval  mAvgTime;
  FSpectrum mAccum;
  FSpectrum mAverage;
  FSpectrum mCompare;

  bool      mSave;
  Time      mSvStart;
  Interval  mSavTime;
  std::string mSvFile;
  std::string mEnableCond;
};

#ifndef __CINT__
//======================================  Inline functions
inline const char* 
PSLSpec::getEnableCond(void) const {
    return mEnableCond.c_str();
}
#endif // !defined(__CINT__)

#endif // !defined(PSLSPEC_HH)
