#ifndef PSLCORR_HH
#define PSLCORR_HH

#include "FSpectrum.hh"
#include "Time.hh"
#include <string>

#include "PSLChan.hh"

//======================================  Correlation monitor class
class PSLCorr {
public:
  //------------------------------------  Constructors and destructors.
  PSLCorr(const std::string& name, const PSLChan* chanA, const PSLChan* chanB);
  PSLCorr(const PSLCorr& x);
  ~PSLCorr(void);

  //------------------------------------  Acessors.
  const char* getChannelA(void) const;
  const char* getChannelB(void) const;
  int getDebug(void) const;
  const char* getEnableCond(void) const;
  std::string getIFO(void) const;
  const char* getName(void) const;
  double getLast(void)  const;
  double getCorr(void) const;
  const char* getTrend(void) const;

  //------------------------------------  Mutators
  void setAvg(Interval avgTime);
  void setCompare(const FSpectrum& sp);
  void setSave(Interval savTime, const std::string& savFile);
  void setAbsLimit(double Alow, double Ahigh);
  void setBand(double Flow, double Fhigh);
  void setDebug(int debug);
  void setDeltLimit(double Dmax);
  void setEnableCond(const std::string& cond);
  void setFracLimit(double Fmax);
  void setFracLimit(double Fmin, double Fmax);
  void setTrend(const std::string& trend);

  //------------------------------------  Processing functions
  bool crunch(void);
  void reset(void);

private:
  std::string     mName;
  const PSLChan*  mChanA;
  const PSLChan*  mChanB;
  double          mCorr;
  std::string     mTrend;
  std::string     mEnableCond;
  double mLast;

  ///  Minimum frequency in band.
  double    mBmin;

  ///  Maximum frequency in band.
  double    mBmax;

  ///  Absolute lower limit
  double    mAmin;

  ///  Absolute upper limit
  double    mAmax;

  ///  Absolute delta upper limit
  double    mDmax;

  ///  Fractional delta upper limit
  double    mFmin;

  ///  Fractional delta upper limit
  double    mFmax;

  int mDebug;
};

#ifndef __CINT__
//======================================  Inline functions
inline double
PSLCorr::getCorr(void) const {
    return mCorr;
}

inline int
PSLCorr::getDebug(void) const {
    return mDebug;
}

inline const char* 
PSLCorr::getEnableCond(void) const {
    return mEnableCond.c_str();
}

inline std::string
PSLCorr::getIFO(void) const {
    return mChanA->getIFO();
}

inline double
PSLCorr::getLast(void) const {
    return mLast;
}

inline const char* 
PSLCorr::getName(void) const {
    return mName.c_str();
}

inline const char* 
PSLCorr::getTrend(void) const {
    return mTrend.c_str();
}

#endif // !defined(__CINT__)

#endif // !defined(PSLCORR_HH)
