/***************************************************************************
    File        : Utils.h
    Description : Implements some usefuls inline functions
 ---------------------------------------------------------------------------
    Begin       : Fri Jul 27 2001
    Copyright   : (C) 2001 by Roberto Grosso
                  All rights reserved
 ***************************************************************************/

#ifndef UTILITIES_H
#define UTILITIES_H

// Libs
#include <iostream>
#include <sstream>
#include <fstream>
#include <vector>
#include <complex>
#include <cstdlib>

// Project Files
#include "Types.h"

namespace gwd {

  // Warning and Error macros
  // use inline functions
  // Warning Macro
  // Version with strings
  inline void Warning(const std::string warningText)
  {
    std::cerr << " WARNING: "
         << warningText
         << std::endl;
  }

  // Version with char*
  inline void Warning(const char* warningText)
  {
    std::cerr << " WARNING: "
         << warningText
         << std::endl;
  }

  //
  // Error Macro
  // Version with string
  inline void Error(const std::string errorText)
  {
    std::cerr << " ERROR: "
              << errorText
              << std::endl;
    exit(1);
  }

  // Version with char*
  inline void Error(const char* errorText)
  {
    std::cerr << " ERROR: "
              << errorText
              << std::endl;
    exit(1);
  }


  inline void plot(const char* filename,Vector& func)
  {
    // open file in binary mode
    std::ofstream ofd(filename,std::ios::binary|std::ios::out);
    // write at once!
    ofd.write((char*)&func[0],(std::streamsize) func.size()*sizeof(double));
    ofd.close();
  }

  inline void plot(const char* filename,std::vector<float>::iterator start,std::vector<float>::iterator end)
  {
    // open file in char mode
    std::ofstream ofd(filename);
    std::vector<float>::iterator p = start;
    while(p != end)
    {
      ofd << (*p) << std::endl;
      ++p;
    }
    ofd.close();
  }
  
  inline void plot(const char* filename,Vector::iterator start,Vector::iterator end)
  {
    std::ofstream ofd(filename);
    Vector::iterator p = start;
    while(p != end)
    {
      ofd.precision(6);
      ofd  << (*p) << std::endl;
      ++p;
    }
    ofd.close();
  }


  inline void plot(const char* filename,std::vector<Complex>& func)
  {
    std::ofstream ofd(filename);
    for (size_t nn = 0; nn < func.size(); nn++)
      ofd << func[nn].real() << std::endl;
    ofd.close();
  }

} // namespace gwd


#endif // __UTILITIES_H
