/***************************************************************************
    File        : PowerSpectrum.cpp
    Description : Implementes class PowerSpectrum
 ---------------------------------------------------------------------------
    Begin       : Thu Dec 11 2003
    Author(s)   : Roberto Grosso
 ***************************************************************************/

#include "PowerSpectrum.h"


// Welch's method for the power spectrum estimation
bool 
gwd::PowerSpectrum::WelchPowerSpectrumDensity(const unsigned int noOfFreq,const double overlap,
                                              const Vector& signal,
                                              Vector& psd)
{
  // Needs DFT
  Fourier dft;

  // Set sizes
  const unsigned int wSize = 2*(noOfFreq - 1);
  // do not allow and overlap larger than 80% of the segment size
  const unsigned int noverlap = overlap < 0.8 ? static_cast<unsigned int>(overlap*wSize) : static_cast<unsigned int>(0.8*wSize);
  // Check input signal size
  if ((wSize - noverlap)  >= (signal.size()-noverlap))
  {
    Singleton* single = Singleton::exemplar();
    single->AppendMessage("gwd::PowerSpectrum::WelchPowerSpectrumDensity: signal used for psd estimation is not long enough");
    return false;
  }

  // Set window
  Vector window;
  Window cw;
  cw.Hanning(wSize,window);
  
  // Set spectrum data
  std::vector<Complex> cdata(noOfFreq);
  // Set auxiliary array
  Vector ct(wSize);

  // Initialize the Fourier Transform
  dft.Init(wSize,ct,cdata);

  // Set psd array
  psd.resize(noOfFreq);
  
  // Compute spectrum
  std::fill(psd.begin(),psd.end(),double(0));
  const double wEnergy = gwd::InnerProduct<double>(window,window);
  int KK = (signal.size() - noverlap) / (wSize - noverlap);
  int idx = 0;
  for (int ii = 0; ii < KK; ii++)
  {
    std::copy(signal.begin()+idx,signal.begin()+idx+wSize,ct.begin());
    std::fill(cdata.begin(),cdata.end(),Complex(0));
    gwd::Multiply<double>(ct,window);
    dft.dft();

    // Compute Energy at frequency beans
    for (int nn = 0; nn < (int)cdata.size(); nn++)
      psd[nn] += AbsoluteSquare(cdata[nn]);

    // update index with overlap
    idx += wSize - noverlap;
  }
  // Normalize
  const double factor = 1./(static_cast<double>(KK*noOfFreq)*wEnergy);
  gwd::Multiply<double>(psd,factor);

  return true;
}
