/***************************************************************************
    File        : FIRFilter.h
    Description : Generates a Notch filter
 ---------------------------------------------------------------------------
    Begin       : Mon Sep 3 2001
    Author(s)   : Roberto Grosso
 ***************************************************************************/

#ifndef __FIR_FILTER_H
#define __FIR_FILTER_H

/*! \file FIRFilter.h
 *  Finite impulse response filtering based on the
 *  overlap-add method.
 *  \brief FIR filtering based on the overlap-add method.
 */

// Libs
#include <algorithm>
#include <limits>
#include <string>
#include <list>
#include <vector>


// Project files
#include "Types.h"
#include "Singleton.h"
#include "Exception.h"
#include "Numeric.h"
#include "Convolution.h"

namespace gwd {

  //! Finit impulse response filter based on the overlap-add method.
  class FIRFilter {
  public:
    /** Default constructor. */
    FIRFilter() {}

    /** Destructor */
    virtual ~FIRFilter() {}

    // Methods
    /**
     * Finite Impulse Response filter of a signal based on the overlap-add method.
     * The filtering operation on each signal piece uses the convolution of the
     * signal with the response filter. The result is written in the answer.
     * @param signal a vector of double precision.
     * @param response the filter, a vector of double precision.
     * @param answer the result of the filtering.
     * @return true in case of success, otherwise false.
     */
    bool Filter(Vector& signal,Vector& response,Vector& answer);
  };

} // namespace gwd
#endif // __FIR_FILTER_H

