/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef XSIL_DIM_HH
#define XSIL_DIM_HH

#include "xsil/xobj.hh"

namespace xsil {
    class Xwriter;
    class xobj;
    class dim;

/**  xsil::dim carries the %XSIL %array object's dimension information.
  *  @memo Array dimension class.
  *  @author J. Zweizig
  *  @version 1.1; Modified December 13, 1999
  *  @ingroup IO_xsil
  */
class dim : public xobj {
public:
    /** Default constructor.
     */
    dim(void);

    /**  Construct an object with a non-zero dimension size and an
      *  optional name. If the name is coded as a null pointer, the 
      *  name attribute is left blank.
      *  \brief Full dimension constructor.
      *  \param Name Dimension name attribute.
      *  \param N    Length of this dimension.
      */
    dim(const char* Name, int N);

    /**  Destroy the dimension object and release its allocated storage.
      *  \brief Destructor.
      */
    ~dim(void);

    /**  The dimension object is written to an XML output stream specified
      *  by the argument object. The calling sequence is kept compatible 
      *  with the xobj abstract class in case it is decided that %dim should 
      *  inherit %xobj.
      *  @memo Write out the dimension object to an XML file.
      *  @param xout XML writer to which the dimension is to be written.
      */
    void Spew(Xwriter& xout) const;

    /**  Clone a dimension object.
      *  @memo Get object type.
      *  @return Object type;
      */
    dim* Clone(void) const;

    /**  Returns a character string "Dim" representing the object type.
      *  @memo Get object type.
      *  @return Object type string;
      */
    const char* getObjType(void) const;

    /**  Get the dimension length.
      *  \brief Get the dimension
      *  \returns Integer length for this dimension.
      */
    int  getDim(void) const;

  /**  Set the dimension length to the integer argument value. 
    *  \brief Set the dimension length.
    *  \param Dim Length of dimension.
    */
    void setDim(int Dim);

private:
    int    mDim;
};

}
#endif  //  XSIL_DIM_HH
