//
//    Base 64 encoding/decoding algorithm. The raw data bytes are 
//    represented as a string ogcharacters, eac corresponding to a 
//    6-bit nibble. THe ordering of the nibbles is such that the high
//    order bits are copied first. Thus the low order bits of a raw byte
//    are contained in the nibble following the one holding the high 
//    order bits.
//
//    The base 64 table
//
#include "xsil/base64.hh"

static const b64data_t* Base64Table = (const b64data_t*)
"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

//
//  Number of bytes of base64 encoded data.
// 
int 
b64Nout(int nIn) {
  return ((nIn+2) / 3) * 4;
}

//
//
//
int 
toBase64(const void* inv, int ilen, b64data_t* out, int olen) {
    int nbit(0), bits(0), nwd(0), oinx(0);
    const unsigned char* in = reinterpret_cast<const unsigned char*>(inv);
    while (nwd<ilen && oinx<olen) {
        if (nbit) bits <<= 8;
	else      bits   = 0;
	bits |= (in[nwd++] & 0xff);
	nbit += 8;
	while (nbit>=6 && oinx<olen) {
	    nbit -= 6;
	    out[oinx++] = Base64Table[(bits>>nbit) & 63];
	}
    }
    if (nbit && oinx<olen) {
        bits <<= 6-nbit;
	out[oinx++] = Base64Table[bits & 63];
    }
    while ((oinx%4) && oinx<olen) out[oinx++] = '=';
    return oinx;
}

//
//
//
static char Base64Inverse[256];
static bool InvOK(false);

//
//
//
int
fromBase64(const b64data_t* in, int ilen, void* outv, int olen) {
  unsigned char* out =  reinterpret_cast<unsigned char*>(outv);
    if (!InvOK) {
        for (int i=0 ; i<256 ; i++) Base64Inverse[i] = -1;
	for (int i=0 ; i<64  ; i++) Base64Inverse[int(Base64Table[i])] = i;
	InvOK = true;
    }

    int nbit(0), bits(0), nwd(0), oinx(0);
    while (nwd<ilen && oinx<olen) {
        if (nbit) bits <<= 6;
	else      bits   = 0;
	bits |=  Base64Inverse[int(in[nwd++])];
	nbit += 6;
	if (nbit>=8) {
	    nbit -= 8;
	    out[oinx++] = (bits>>nbit) & 255;
	}
    }
    return oinx;
}


