#include "file_stream.hh"
#include "lsmp_prod.hh"
#include "SigFlag.hh"
#include <string>
#include <fstream>
#include <iostream>

using namespace std;

int debug = 1;

void
syntax(void) {
   cout << "Command line syntax: " << endl;
   cout << "shmover <shm-dir> <partition>" << endl;
}

int
main(int argc, const char* argv[]) {
   if (argc <=2) {
       syntax();
       return 1;
   }

   file_stream fs(argv[1]);
   fs.set_debug(debug);

   LSMP_PROD part(argv[2]);
   streampos parlen =part.getBufferLength();

   SigFlag term(SIGTERM);
   while (!term) {
      if (!fs.wait_file()) continue;
      while (fs.test_file()) {
         string file = fs.next_file();
	 if (debug) cout << "read next file: " << file << endl;
         ifstream is(file.c_str(), std::ifstream::binary);
         if (!is.is_open()) {
	    cerr << "Unable to open file: " << file << endl;
	    continue;
         }
         //----------------------------  Get length of file
         is.seekg (0, is.end);
         streampos length = is.tellg();
	 if (debug) cout << "file length: " << length << endl;
         is.seekg (0, is.beg);
         if (length > parlen) continue;

         //----------------------------  Get a buffer address
         char* buf = part.get_buffer();
         if (!buf) {
	    cerr << "Unable to get a buffer from partition: " << argv[2] << endl;           continue;
         }

         //----------------------------  read the frame
         is.read(buf, length);
         int readlen = is.gcount();
	 if (readlen < length) {
	    perror("frame file read failure");
	    cerr << "File length: " << length 
		 << " bytes read: " << readlen << endl;
	    part.return_buffer();
         }
         else {
	    part.release(length);
         }
      }
   }
}

