//  This fixes a major stupidity in the solaris socket header when used 
//  with a non-solaris compiler (e.g. g++).
//
//  The solaris socket header defines the following symbols:
//      bind    __xnet_bind
//      connect __xnet_connect
//
#if defined(__cplusplus) && defined(sun)

#ifdef bind
#undef bind
inline int 
bind(int s, struct sockaddr* a, socklen_t l) {
    return __xnet_bind(s, a, l);
}
#endif

#ifdef connect
#undef connect
inline int 
connect(int s, struct sockaddr* a, socklen_t l) {
    return __xnet_connect(s, a, l);
}
#endif

#endif // defined(__cplusplus) && defined(sun)

