/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef LMSG_TCPSOCKET_HH
#define LMSG_TCPSOCKET_HH
#include "lmsg/Socket.hh"

namespace lmsg {
  class SocketPool;

  /**  Class to manipulate TCP sockets.
    *  @memo Socket class.
    *  @author  John Zweizig
    *  @version 1.1; Modified April 21, 2000
    *  @ingroup IO_lmsg
    */
  class TCPSocket : public Socket {
  private:
    /**  Create a TCP Socket from an existing socket descriptor.
      *  @memo Construct a TCP socket.
      *  @param s Existing socket descriptor.
      */
    TCPSocket(int s);

  public:
    /**  Allocate a TCP/IP socket and bind it to the specified address.
      *  If no address pointer is specified, an unused port address will 
      *  be allocated.
      *  @memo Construct a TCP socket.
      *  @param addr Pointer to the address to which the socket will be bound.
      */
    TCPSocket(const MsgAddr* addr=0);

    /**  Release the socket and delete all asociated storage.
      *  @memo Destructor
      */
    ~TCPSocket(void);

    /**  Wait for a connection to be made to this socket.
      */
    error_type waitConnect(wtime_type time, TCPSocket** ts=0);

    /**  Listen for a connection to be made to this socket.
      */
    error_type listen(int nListen=1);

    error_type disconnect(void);
  };
} // namespace lmsg

#endif // LMSG_TCPSOCKET_HH
